/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.gw.admin.ui.DsuiModel;
import com.novell.gw.admin.ui.DsuiResource;

public class DsuiAttrDescriptor {
    private static final String COLON = DsuiResource.getString("colon");
    protected boolean readRights;
    protected boolean writeRights;
    protected String attributeName;
    protected String label;
    private Object defaultValue;

    public DsuiAttrDescriptor(int n) {
        this(String.valueOf(n));
    }

    public DsuiAttrDescriptor(String string) {
        this.setAttribute(string);
    }

    public DsuiAttrDescriptor(int n, String string) {
        this(String.valueOf(n), string);
    }

    public DsuiAttrDescriptor(String string, String string2) {
        this.setAttribute(string, string2);
    }

    public void setAttribute(String string) {
        this.setAttribute(string, DsuiResource.getAttrLabel(string));
    }

    public void setAttribute(String string, String string2) {
        this.attributeName = string;
        this.label = string2;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getLabel() {
        if (!this.label.endsWith(COLON)) {
            return this.label + COLON;
        }
        return this.label;
    }

    public String getPureLabel() {
        return this.label;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public boolean hasReadRights() {
        return this.readRights;
    }

    public boolean hasWriteRights() {
        return this.writeRights;
    }

    public void updateRights(DsuiModel dsuiModel) {
        this.readRights = dsuiModel.canRead(this.attributeName);
        this.writeRights = dsuiModel.canWrite(this.attributeName);
    }
}

