/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.IncrementBox;
import com.novell.gw.util.Debug;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IncrementEditor
extends DsuiView {
    public static final double DEFAULT_SECOND_LABEL_WEIGHT = 0.7;
    private IncrementBox incrementBox;
    private JLabel label;
    private JLabel unitsLabel;

    public IncrementEditor() {
        this(new DsuiLayout(), 0.7, 0, Integer.MAX_VALUE);
    }

    public IncrementEditor(double d) {
        this(new DsuiLayout(), d, 0, Integer.MAX_VALUE);
    }

    public IncrementEditor(DsuiLayout dsuiLayout) {
        this(dsuiLayout, 0.7, 0, Integer.MAX_VALUE);
    }

    public IncrementEditor(DsuiLayout dsuiLayout, double d) {
        this(dsuiLayout, d, 0, Integer.MAX_VALUE);
    }

    public IncrementEditor(int n, int n2) {
        this(new DsuiLayout(), 0.7, n, n2);
    }

    public IncrementEditor(DsuiLayout dsuiLayout, int n, int n2) {
        this(dsuiLayout, 0.7, n, n2);
    }

    public IncrementEditor(DsuiLayout dsuiLayout, double d, int n, int n2) {
        this.setLayout(dsuiLayout);
        this.label = new JLabel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.incrementBox = new IncrementBox(n, n2, 0);
        this.incrementBox.setHorizontalAlignment(4);
        this.incrementBox.setPreferredSize(new Dimension((int)(100.0 * (1.0 - d)), 23));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0 - d;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.incrementBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalStrut(5));
        this.unitsLabel = new JLabel();
        this.unitsLabel.setPreferredSize(new Dimension((int)(100.0 * d), 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = d;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.unitsLabel, gridBagConstraints);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.add((Component)jPanel, DsuiLayout.FIELD);
    }

    public Object getEventDispatcher() {
        return this.incrementBox;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        if (this.unitsLabel.getText().length() == 0) {
            try {
                String string2 = DsuiResource.getString(this.descriptor.getAttributeName() + ".units");
                this.unitsLabel.setText(string2);
                NConeFactory.novellJLabel((JLabel)this.label, (String)(string + " : " + string2), (String)"");
                NConeFactory.novellJTextField((JTextField)this.incrementBox.getTextField(), (String)(Loc.removeHotChar((String)this.label.getText()) + " " + Loc.removeHotChar((String)this.unitsLabel.getText())), (String)"");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.setInterval();
    }

    public void setUnitsLabel(String string) {
        this.unitsLabel.setText(string);
    }

    private void setInterval() {
        try {
            String string = DsuiResource.getString(this.descriptor.getAttributeName() + ".interval");
            int n = Integer.parseInt(string);
            this.incrementBox.setInterval(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getValue() {
        int n = this.incrementBox.getValue();
        return new Integer(n);
    }

    public void setEnabled(boolean bl) {
        this.incrementBox.setEnabled(bl);
    }

    public void setLabelEnabled(boolean bl) {
        this.label.setEnabled(bl);
        this.unitsLabel.setEnabled(bl);
    }

    public void setLabelVisible(boolean bl) {
        this.label.setVisible(bl);
    }

    public void setValue(Object object) {
        if (object != null) {
            int n;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else {
                try {
                    n = Integer.parseInt(object.toString());
                }
                catch (ClassCastException classCastException) {
                    n = 0;
                    Debug.trace((String)("STRINGEDITOR: cast exception:attr id=" + this.descriptor.getAttributeName() + "|value=" + n + "|value class=" + object.getClass().getName()));
                }
            }
            this.incrementBox.setValue(n);
            NConeFactory.makeRelation((JLabel)this.label, (JTextField)this.incrementBox.getTextField());
            NConeFactory.novellJTextField((JTextField)this.incrementBox.getTextField(), (String)(Loc.removeHotChar((String)this.label.getText()) + " " + Loc.removeHotChar((String)this.unitsLabel.getText())), (String)"");
        }
    }
}

