/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.NConeFactory;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.widgets.NIntTextField;
import com.novell.application.console.widgets.NJTextField;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiModel;
import com.novell.gw.admin.widgets.GWTextField;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.TCPAddressEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IpCombo
extends JPanel
implements ActionListener {
    private GWTextField idomField;
    private JButton editButton;
    private JDialog parent;
    private int defaultPort = -1;
    private String idomAttrId;
    private String portAttrId;
    private String portLabel;
    private String dlgTitle;
    private String helpTarget;
    private DsuiModel model;

    public IpCombo(JDialog jDialog, String string, DsuiModel dsuiModel, String string2) {
        this(jDialog, string, dsuiModel, string2, null, null);
    }

    public IpCombo(JDialog jDialog, String string, DsuiModel dsuiModel, String string2, String string3, String string4) {
        this.parent = jDialog;
        this.dlgTitle = string;
        this.model = dsuiModel;
        this.idomAttrId = string2;
        this.portAttrId = string3;
        this.portLabel = string4;
        this.initComponents();
        this.fillIpField();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.idomField = new GWTextField();
        this.idomField.setOpaque(false);
        this.idomField.setEditable(false);
        this.add((Component)this.idomField, "Center");
        int n = this.idomField.getPreferredSize().height;
        this.editButton = RB.getIconButton("edit.gif");
        this.editButton.getAccessibleContext().setAccessibleName(RB.getString("EditImageKey"));
        this.editButton.setPreferredSize(new Dimension(n, n));
        this.editButton.addActionListener(this);
        this.add((Component)this.editButton, "East");
    }

    private void fillIpField() {
        String string = (String)this.model.getAttrValue(this.idomAttrId);
        Integer n = null;
        if (this.portAttrId != null) {
            n = (Integer)this.model.getAttrValue(this.portAttrId);
        }
        if (string != null && !string.equals("")) {
            String string2 = string;
            if (n != null) {
                string2 = string2 + ":" + n;
            }
            this.idomField.setText(string2);
        } else {
            this.idomField.setText("");
        }
    }

    public void setEnabled(boolean bl) {
        this.idomField.setEnabled(bl);
        this.editButton.setEnabled(bl);
    }

    public void setDefaultPort(int n) {
        this.defaultPort = n;
    }

    public void setHelpTarget(String string) {
        this.helpTarget = string;
    }

    public GWTextField getIdomField() {
        return this.idomField;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IpDlg ipDlg = new IpDlg();
        ipDlg.setLocationRelativeTo(this);
        ipDlg.show();
    }

    private class IpDlg
    extends JDialog
    implements ActionListener,
    ChangeListener {
        private TCPAddressEditor tcpEditor;
        private NIntTextField portField;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;

        public IpDlg() {
            super(IpCombo.this.parent, IpCombo.this.dlgTitle, true);
            this.initComponents();
            this.fillFields();
            this.addActions();
            this.pack();
        }

        private void initComponents() {
            JPanel jPanel;
            Container container = this.getContentPane();
            container.setLayout(new GridBagLayout());
            this.tcpEditor = new TCPAddressEditor();
            this.tcpEditor.setPreferredSize(new Dimension(350, this.tcpEditor.getPreferredSize().height));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            container.add((Component)this.tcpEditor, gridBagConstraints);
            if (IpCombo.this.portAttrId != null && IpCombo.this.portLabel != null) {
                jPanel = new JPanel();
                jPanel.setLayout(new DsuiLayout());
                JLabel jLabel = new JLabel(IpCombo.this.portLabel);
                jPanel.add((Component)jLabel, DsuiLayout.LABEL);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                this.portField = new NIntTextField(4, 0L, 65535L);
                this.portField.addKeyListener((KeyListener)new KeyAdapter(this){
                    private final /* synthetic */ IpDlg this$1;
                    {
                        this.this$1 = ipDlg;
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                        IpDlg.access$400(this.this$1);
                    }
                });
                NConeFactory.makeRelation((JLabel)jLabel, (NJTextField)this.portField);
                jPanel2.add((Component)this.portField, "West");
                jPanel.add((Component)jPanel2, DsuiLayout.FIELD);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 10, 0, 10);
                container.add((Component)jPanel, gridBagConstraints);
            }
            jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(1, 3, 5, 0));
            this.okButton = RB.getUnsizedButton("okKey");
            this.okButton.setEnabled(false);
            this.okButton.addActionListener(this);
            jPanel.add(this.okButton);
            this.cancelButton = RB.getUnsizedButton("cancelKey");
            this.cancelButton.addActionListener(this);
            jPanel.add(this.cancelButton);
            this.helpButton = RB.getUnsizedButton("helpKey");
            this.helpButton.setEnabled(IpCombo.this.helpTarget != null);
            this.helpButton.addActionListener(this);
            jPanel.add(this.helpButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(20, 10, 10, 10);
            container.add((Component)jPanel, gridBagConstraints);
            this.getRootPane().setDefaultButton(this.okButton);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ IpDlg this$1;
                {
                    this.this$1 = ipDlg;
                }

                public void windowOpened(WindowEvent windowEvent) {
                    IpDlg.access$600(this.this$1).requestFocus();
                }
            });
        }

        private void fillFields() {
            String string = (String)IpCombo.this.model.getAttrValue(IpCombo.this.idomAttrId);
            if (string != null) {
                this.tcpEditor.setValue(string);
            }
            if (IpCombo.this.portAttrId != null) {
                Integer n = (Integer)IpCombo.this.model.getAttrValue(IpCombo.this.portAttrId);
                if (n != null) {
                    this.portField.setIntValue(n.intValue());
                } else if (IpCombo.this.defaultPort != -1) {
                    this.portField.setIntValue(IpCombo.this.defaultPort);
                }
            }
        }

        private void addActions() {
            this.tcpEditor.addChangeListener(this);
        }

        private void updateOkButton() {
            boolean bl = this.tcpEditor.isAddressValid();
            if (!bl) {
                bl = this.tcpEditor.getValue().equals("");
            }
            this.okButton.setEnabled(bl);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateOkButton();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.okButton) {
                IpCombo.this.model.setAttrValue(IpCombo.this.idomAttrId, this.tcpEditor.getValue());
                if (IpCombo.this.portAttrId != null) {
                    if (this.portField.isDataValid()) {
                        IpCombo.this.model.setAttrValue(IpCombo.this.portAttrId, new Integer(this.portField.getIntValue()));
                    } else {
                        IpCombo.this.model.setAttrValue(IpCombo.this.portAttrId, null);
                    }
                }
                IpCombo.this.fillIpField();
                this.dispose();
            } else if (object == this.cancelButton) {
                this.dispose();
            } else if (object == this.helpButton) {
                Shell shell = MainShell.getInstance();
                shell.launchHelp("novellgwadmin", IpCombo.this.helpTarget, (Window)this);
            }
        }

        static /* synthetic */ void access$400(IpDlg ipDlg) {
            ipDlg.updateOkButton();
        }

        static /* synthetic */ TCPAddressEditor access$600(IpDlg ipDlg) {
            return ipDlg.tcpEditor;
        }
    }
}

