/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.GWComboBox;
import com.novell.gw.util.Debug;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class LanguageEditor
extends DsuiView {
    private JLabel label;
    private GWComboBox cb;
    private Integer valueCache;
    private int[] langID;

    public LanguageEditor() {
        this.setLayout(new DsuiLayout());
        this.label = new JLabel();
        this.cb = new GWComboBox();
        this.cb.setLightWeightPopupEnabled(false);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.add((Component)this.cb, DsuiLayout.FIELD);
    }

    public Object getEventDispatcher() {
        return this.cb;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        NConeFactory.makeRelation((JLabel)this.label, (JComboBox)this.cb);
        this.buildList();
    }

    public void setEnabled(boolean bl) {
        this.cb.setEnabled(bl);
    }

    public void setValue(Object object) {
        if (object != null) {
            int n = 13;
            if (object instanceof Integer) {
                this.valueCache = (Integer)object;
                for (int i = 0; i < this.langID.length; ++i) {
                    if (this.langID[i] != this.valueCache) continue;
                    n = i;
                }
            } else {
                try {
                    this.valueCache = new Integer(object.toString());
                    for (int i = 0; i < this.langID.length; ++i) {
                        if (this.langID[i] != this.valueCache) continue;
                        n = i;
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.cb.setSelectedIndex(n);
        }
    }

    public Object getValue() {
        return new Integer(this.langID[this.cb.getSelectedIndex()]);
    }

    private void buildList() {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(DsuiResource.getString("languageIndexes"), ",");
        int n2 = stringTokenizer.countTokens();
        this.langID = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.langID[i] = Integer.parseInt(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(DsuiResource.getString("languages"), ",");
        n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        LanguageEditor.sortLanguageArrays(stringArray, this.langID);
        for (n = 0; n < n2; ++n) {
            this.cb.addItem(stringArray[n]);
        }
    }

    public static void sortLanguageArrays(String[] stringArray, int[] nArray) {
        int n = stringArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n - 1; ++n3) {
            n4 = n3;
            n5 = 0;
            while (n3 + n5 < n) {
                if (stringArray[n4].compareToIgnoreCase(stringArray[n3 + n5]) > 0) {
                    n4 = n3 + n5;
                    Debug.trace((String)("  langStrs[startIndex]: " + stringArray[n3] + " langStrs[lowestIndex]: " + stringArray[n4]));
                }
                ++n5;
            }
            if (n4 == n3) continue;
            String string = stringArray[n3];
            n2 = nArray[n3];
            stringArray[n3] = stringArray[n4];
            nArray[n3] = nArray[n4];
            stringArray[n4] = string;
            nArray[n4] = n2;
        }
    }
}

