/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.GWComboBox;
import com.novell.gw.util.Debug;
import com.novell.service.nds.NdsInteger;
import java.awt.Component;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SelectionEditor
extends DsuiView {
    private JLabel label;
    private JComboBox cb;
    private Integer valueCache;

    public SelectionEditor() {
        this(new DsuiLayout());
    }

    public SelectionEditor(DsuiLayout dsuiLayout) {
        this.setLayout(dsuiLayout);
        this.label = new JLabel();
        this.cb = new GWComboBox();
        this.cb.setLightWeightPopupEnabled(false);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.add((Component)this.cb, DsuiLayout.FIELD);
    }

    public Object getEventDispatcher() {
        return this.cb;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        NConeFactory.makeRelation((JLabel)this.label, (JComboBox)this.cb);
        this.buildList();
    }

    public void setEnabled(boolean bl) {
        this.cb.setEnabled(bl);
    }

    public Object getValue() {
        return new Integer(this.cb.getSelectedIndex() + 1);
    }

    public void setValue(Object object) {
        if (object != null) {
            if (object instanceof Integer) {
                this.valueCache = (Integer)object;
            } else if (object instanceof NdsInteger) {
                this.valueCache = new Integer(((NdsInteger)object).intValue());
            } else {
                try {
                    Integer n;
                    this.valueCache = n = new Integer(object.toString());
                }
                catch (Exception exception) {
                    this.valueCache = null;
                    return;
                }
            }
            this.cb.setSelectedIndex(this.valueCache - 1);
        }
    }

    private void buildList() {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(DsuiResource.getAttrBounds(this.descriptor.getAttributeName()), ",");
            while (stringTokenizer.hasMoreElements()) {
                this.cb.addItem((String)stringTokenizer.nextElement());
            }
        }
        catch (MissingResourceException missingResourceException) {
            Debug.trace((String)("SELECTIONEDITOR:EXCEPTION:key=" + missingResourceException.getKey()));
        }
    }
}

