/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.ui.DsuiLayout;
import com.novell.gw.admin.ui.DsuiView;
import com.novell.gw.admin.widgets.GwTextArea;
import com.novell.gw.util.Debug;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextAreaEditor
extends DsuiView
implements FocusListener {
    JTextArea textArea;
    JLabel label;
    JScrollPane scrollPane;

    public TextAreaEditor() {
        this(new DsuiLayout());
    }

    public TextAreaEditor(DsuiLayout dsuiLayout) {
        dsuiLayout.preferredHeight = 42;
        this.setLayout(dsuiLayout);
        this.initComponents();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.label.setVerticalAlignment(1);
        this.add((Component)this.label, DsuiLayout.LABEL);
        this.textArea = new GwTextArea();
        this.textArea.addFocusListener(this);
        this.textArea.setFont(new JTextField().getFont());
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, DsuiLayout.FIELD);
    }

    public Object getEventDispatcher() {
        return this.textArea;
    }

    public void setLabel(String string) {
        this.label.setText(string);
        NConeFactory.makeRelation((JLabel)this.label, (JTextArea)this.textArea);
    }

    public void setLabelEnabled(boolean bl) {
        this.label.setEnabled(bl);
    }

    public Object getValue() {
        String string = this.textArea.getText();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public void setValue(Object object) {
        if (object != null) {
            String string;
            try {
                string = (String)object;
            }
            catch (ClassCastException classCastException) {
                string = object.toString();
                Debug.trace((String)("STRINGEDITOR: cast exception:attr id=" + this.descriptor.getAttributeName() + "|value=" + string + "|value class=" + object.getClass().getName()));
            }
            this.textArea.setText(string);
            this.textArea.setCaretPosition(0);
        }
    }

    public void setEnabled(boolean bl) {
        this.textArea.setEnabled(bl);
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.textArea) {
            NConeFactory.novellJTextArea((JTextArea)this.textArea, (String)(Loc.removeHotChar((String)this.label.getText()) + this.textArea.getText()), (String)"");
        }
    }
}

