/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.mvc.MvcModel;
import com.novell.gw.admin.ui.mvc.MvcModelListener;
import com.novell.gw.ds.ExtendedDirContext;
import com.novell.gw.ds.Rights;
import com.novell.utility.localization.Loc;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public abstract class DirCtxModel
implements MvcModel,
PropertyChangeListener {
    private boolean useColon = true;
    protected String attrName;
    private String label;
    private Object defaultValue;
    private ArrayList listeners;
    protected ExtendedDirContext gwObj;

    public abstract Object getRealValue();

    public abstract void setValue(Object var1);

    protected DirCtxModel(ExtendedDirContext extendedDirContext, String string) {
        this.gwObj = extendedDirContext;
        this.attrName = string;
        this.listeners = new ArrayList(1);
        extendedDirContext.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public final void addModelListener(MvcModelListener mvcModelListener) {
        this.listeners.add(mvcModelListener);
    }

    public final boolean canRead() {
        Rights rights = this.gwObj.getAttrRights(this.attrName);
        return rights.hasReadRights();
    }

    public final boolean canWrite() {
        Rights rights = this.gwObj.getAttrRights(this.attrName);
        return rights.hasWriteRights();
    }

    public String getAccessibleLabel() {
        this.loadLabel();
        return Loc.removeHotChar((String)this.label);
    }

    public final String getLabel() {
        this.loadLabel();
        if (this.useColon && !this.label.endsWith(DsuiResource.COLON)) {
            return this.label + DsuiResource.COLON;
        }
        return this.label;
    }

    private final void loadLabel() {
        if (this.label == null) {
            this.label = DsuiResource.getAttrLabel(this.attrName, false);
        }
    }

    public final void setLabel(String string) {
        this.label = string;
    }

    public final Object getValue() {
        Object object = this.getRealValue();
        return object != null ? object : this.defaultValue;
    }

    public final void setUseColon(boolean bl) {
        this.useColon = bl;
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.attrName.equals(propertyChangeEvent.getPropertyName())) {
            this.fireModelChanged();
        }
    }

    protected final void setDefaultValue(Object object) {
        this.defaultValue = object;
        this.fireModelChanged();
    }

    protected final void fireModelChanged() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            MvcModelListener mvcModelListener = (MvcModelListener)this.listeners.get(i);
            mvcModelListener.modelChanged();
        }
    }
}

