/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.mvc.DirCtxModel;
import com.novell.gw.admin.ui.mvc.ValueMapping;
import com.novell.gw.ds.ExtendedDirContext;
import com.novell.gw.util.Debug;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.naming.NamingException;

public class MappedModel
extends DirCtxModel {
    private ValueMapping[] mappings;

    public MappedModel(ExtendedDirContext extendedDirContext, int n) {
        this(extendedDirContext, n, null);
    }

    public MappedModel(ExtendedDirContext extendedDirContext, int n, String string) {
        super(extendedDirContext, String.valueOf(n));
        this.init(string);
    }

    private void init(String string) {
        try {
            String string2 = string == null ? DsuiResource.getString(this.attrName + ".mapping") : DsuiResource.getString(string + ".mapping");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            ArrayList<ValueMapping> arrayList = new ArrayList<ValueMapping>();
            while (stringTokenizer.hasMoreTokens()) {
                Integer n = new Integer(stringTokenizer.nextToken());
                String string3 = stringTokenizer.nextToken();
                ValueMapping valueMapping = new ValueMapping(n, string3);
                arrayList.add(valueMapping);
            }
            int n = arrayList.size();
            this.mappings = new ValueMapping[n];
            arrayList.toArray(this.mappings);
        }
        catch (MissingResourceException missingResourceException) {
            Debug.traceException((Throwable)missingResourceException);
        }
    }

    public ValueMapping[] getMappings() {
        return this.mappings;
    }

    public Object getRealValue() {
        try {
            Object object = this.gwObj.getAttrValue(this.attrName);
            return this.getMapping(object);
        }
        catch (NamingException namingException) {
            Debug.traceException((Throwable)namingException);
            return null;
        }
    }

    public void setDefaultMapValue(Integer n) {
        ValueMapping valueMapping = this.getMapping(n);
        this.setDefaultValue(valueMapping);
    }

    public void setValue(Object object) {
        try {
            ValueMapping valueMapping = (ValueMapping)object;
            this.gwObj.setAttrValue(this.attrName, valueMapping.value);
        }
        catch (NamingException namingException) {
            Debug.traceException((Throwable)namingException);
        }
    }

    private ValueMapping getMapping(Object object) {
        if (object != null) {
            for (int i = 0; i < this.mappings.length; ++i) {
                if (!object.equals(this.mappings[i].value)) continue;
                return this.mappings[i];
            }
        }
        return null;
    }
}

