/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.ui.mvc;

import com.novell.gw.admin.ui.DsuiResource;
import com.novell.gw.admin.ui.mvc.ValueFormat;
import com.novell.gw.util.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.swing.table.AbstractTableModel;

public class SearchTableModel
extends AbstractTableModel {
    private String[] attrNames;
    private String[] columnNames;
    private HashMap formatMap;
    private ArrayList resultList;

    public SearchTableModel(String[] stringArray) {
        this.attrNames = stringArray;
        int n = stringArray.length;
        this.columnNames = new String[n];
        this.resultList = new ArrayList();
    }

    public void setFormat(String string, ValueFormat valueFormat) {
        if (this.formatMap == null) {
            this.formatMap = new HashMap();
        }
        this.formatMap.put(string, valueFormat);
    }

    public void setData(NamingEnumeration namingEnumeration) {
        try {
            int n = this.resultList.size();
            if (n > 0) {
                this.resultList.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
            if (namingEnumeration.hasMore()) {
                int n2;
                int n3 = n2 = this.resultList.size();
                while (namingEnumeration.hasMore()) {
                    SearchResult searchResult = (SearchResult)namingEnumeration.next();
                    this.resultList.add(n3, searchResult);
                    ++n3;
                }
                this.fireTableRowsInserted(n2, n3 - 1);
            }
        }
        catch (NamingException namingException) {
            Debug.traceException((Throwable)namingException);
        }
    }

    public String getColumnName(int n) {
        try {
            if (this.columnNames[n] == null) {
                String string = this.attrNames[n];
                this.columnNames[n] = DsuiResource.getAttrLabel(string, false);
            }
            return this.columnNames[n];
        }
        catch (RuntimeException runtimeException) {
            Debug.traceException((Throwable)runtimeException);
            throw runtimeException;
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.resultList.size();
    }

    public Object getValueAt(int n, int n2) {
        try {
            SearchResult searchResult = (SearchResult)this.resultList.get(n);
            Attributes attributes = searchResult.getAttributes();
            String string = this.attrNames[n2];
            Attribute attribute = attributes.get(string);
            if (attribute != null) {
                ValueFormat valueFormat;
                Object object = attribute.get();
                if (this.formatMap != null && (valueFormat = (ValueFormat)this.formatMap.get(string)) != null) {
                    return valueFormat.getFormatValue(object);
                }
                return object;
            }
        }
        catch (NamingException namingException) {
            Debug.traceException((Throwable)namingException);
        }
        return null;
    }

    public void addResult(SearchResult searchResult) {
        int n = this.resultList.size();
        this.resultList.add(n, searchResult);
        this.fireTableRowsInserted(n, n);
    }

    public SearchResult getResult(int n) {
        return (SearchResult)this.resultList.get(n);
    }

    public SearchResult removeResult(int n) {
        SearchResult searchResult = (SearchResult)this.resultList.remove(n);
        this.fireTableRowsDeleted(n, n);
        return searchResult;
    }
}

