/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.SmartBits;
import com.novell.gw.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class BlackoutSchedule {
    public static final int ACTIVE_PERIODIC = 1;
    public static final int ACTIVE_DAILY = 2;
    public static final int ACTIVE_WEEKLY = 3;
    public static final int USE_PARENT_SCHEDULE = 1;
    public static final int USE_THIS_SCHEDULE = 2;
    public static final int USE_NO_SCHEDULE = 3;
    public static final int PROTOCOL_SNMP = 1;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final long MILLIS_PER_DAY = 86400000L;
    private long time = 0L;
    private int selectedSchedule = 1;
    private int scheduleUsage = 1;
    private int blackoutUsage = 1;
    private int protocol = 1;
    private PollDaily pollDaily = new PollDaily();
    private PollWeekly pollWeekly = new PollWeekly();
    private PollBlackout pollBlackout = new PollBlackout();
    private PollPeriodic pollPeriodic = new PollPeriodic();
    private PollSettings pollSettings = new PollSettings();
    private OctetStreamParser parser = new OctetStreamParser();
    private Vector unknownScheduleChunks = new Vector();
    private Vector unknownBlackoutChunks = new Vector();

    public void dumpByteArray(byte[] byArray) {
        if (Debug.trace) {
            for (int i = 0; i < byArray.length; ++i) {
                if (i % 16 == 0) {
                    Debug.trace((String)"");
                }
                Debug.trace((String)("0x" + Integer.toHexString(byArray[i]).toUpperCase() + " "));
            }
            Debug.trace((String)"");
        }
    }

    public int getPeriodicHours() {
        return this.pollPeriodic.getHours();
    }

    public int getPeriodicMinutes() {
        return this.pollPeriodic.getMinutes();
    }

    public void setPeriodicHours(int n) {
        this.pollPeriodic.setHours(n);
    }

    public void setPeriodicMinutes(int n) {
        this.pollPeriodic.setMinutes(n);
    }

    public int getSelectedSchedule() {
        return this.selectedSchedule;
    }

    public void setSelectedSchedule(int n) {
        this.selectedSchedule = n;
    }

    public SmartBits getDailySchedule() {
        return this.pollDaily.getValue();
    }

    public void setDailySchedule(SmartBits smartBits) {
        this.pollDaily.setValue(smartBits);
    }

    public SmartBits[] getWeeklySchedule() {
        return this.pollWeekly.getValue();
    }

    public void setWeeklySchedule(SmartBits[] smartBitsArray) {
        this.pollWeekly.setValue(smartBitsArray);
    }

    public void setScheduleUsage(int n) {
        this.scheduleUsage = n;
    }

    public int getScheduleUsage() {
        return this.scheduleUsage;
    }

    public void setBlackoutUsage(int n) {
        this.blackoutUsage = n;
    }

    public int getBlackoutUsage() {
        return this.blackoutUsage;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setRetries(int n) {
        this.pollSettings.setRetries(n);
    }

    public int getRetries() {
        return this.pollSettings.getRetries();
    }

    public void setTimeout(int n) {
        this.pollSettings.setTimeout(n);
    }

    public int getTimeout() {
        return this.pollSettings.getTimeout();
    }

    public void setEscalate(int n) {
        this.pollSettings.setEscalate(n);
    }

    public int getEscalate() {
        return this.pollSettings.getEscalate();
    }

    public void setAlertDeferral(int n) {
        this.pollSettings.setAlertDeferral(n);
    }

    public int getAlertDeferral() {
        return this.pollSettings.getAlertDeferral();
    }

    public void setScheduleValues(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.parser.parseHeader(byteArrayInputStream);
        this.parseChunks(byteArrayInputStream, true);
    }

    public void setBlackoutValues(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.pollBlackout = new PollBlackout();
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.parser.parseHeader(byteArrayInputStream);
            this.parseChunks(byteArrayInputStream, false);
        }
    }

    public void setBlackoutValues(int[][] nArray) {
        this.pollBlackout.setValues(nArray);
    }

    public int[][] getBlackoutRanges() {
        return this.pollBlackout.getValue();
    }

    public void dumpBlackout() {
        this.pollBlackout.dumpBlackout();
    }

    public void setTime(long l) {
        this.time = l;
    }

    public long getTime() {
        return this.time;
    }

    protected void parseChunks(ByteArrayInputStream byteArrayInputStream, boolean bl) throws IOException {
        block10: while (byteArrayInputStream.available() > 0) {
            byte by = (byte)byteArrayInputStream.read();
            switch (by) {
                case 80: {
                    this.pollPeriodic.setValue(byteArrayInputStream);
                    continue block10;
                }
                case 68: {
                    this.pollDaily.setValue(byteArrayInputStream);
                    continue block10;
                }
                case 87: {
                    this.pollWeekly.setValue(byteArrayInputStream);
                    continue block10;
                }
                case 66: {
                    this.pollBlackout.setValue(byteArrayInputStream);
                    continue block10;
                }
                case 83: {
                    byteArrayInputStream.skip(4L);
                    this.selectedSchedule = byteArrayInputStream.read();
                    continue block10;
                }
                case 85: {
                    byteArrayInputStream.skip(4L);
                    if (bl) {
                        this.scheduleUsage = byteArrayInputStream.read();
                        continue block10;
                    }
                    this.blackoutUsage = byteArrayInputStream.read();
                    continue block10;
                }
                case 112: {
                    byteArrayInputStream.skip(4L);
                    this.protocol = byteArrayInputStream.read();
                    continue block10;
                }
                case 115: {
                    this.pollSettings.setValue(byteArrayInputStream);
                    continue block10;
                }
            }
            byte[] byArray = this.parser.readUnknownChunk(byteArrayInputStream);
            if (bl) {
                this.unknownScheduleChunks.addElement(new UnknownChunk(by, byArray));
                continue;
            }
            this.unknownBlackoutChunks.addElement(new UnknownChunk(by, byArray));
        }
    }

    private void writeSelectedSchedule(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byte[] byArray = new byte[]{new Integer(this.selectedSchedule).byteValue()};
        byArray = this.parser.createChunk((byte)83, byArray);
        byteArrayOutputStream.write(byArray);
    }

    private void writeScheduleUsage(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byte[] byArray = new byte[]{new Integer(this.scheduleUsage).byteValue()};
        byArray = this.parser.createChunk((byte)85, byArray);
        byteArrayOutputStream.write(byArray);
    }

    private void writeBlackoutUsage(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byte[] byArray = new byte[]{new Integer(this.blackoutUsage).byteValue()};
        byArray = this.parser.createChunk((byte)85, byArray);
        byteArrayOutputStream.write(byArray);
    }

    private void writeProtocol(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        byte[] byArray = new byte[]{new Integer(this.protocol).byteValue()};
        byArray = this.parser.createChunk((byte)112, byArray);
        byteArrayOutputStream.write(byArray);
    }

    private void writeUnknownChunks(ByteArrayOutputStream byteArrayOutputStream, Vector vector) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            UnknownChunk unknownChunk = (UnknownChunk)vector.elementAt(i);
            byte[] byArray = this.parser.createChunk(unknownChunk.type, unknownChunk.data);
            byteArrayOutputStream.write(byArray);
        }
    }

    public byte[] getScheduleByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.parser.writeHeader(byteArrayOutputStream);
        this.writeUnknownChunks(byteArrayOutputStream, this.unknownScheduleChunks);
        this.writeSelectedSchedule(byteArrayOutputStream);
        this.writeScheduleUsage(byteArrayOutputStream);
        this.writeProtocol(byteArrayOutputStream);
        this.pollPeriodic.writePeriodic(byteArrayOutputStream);
        this.pollDaily.write(byteArrayOutputStream);
        this.pollWeekly.write(byteArrayOutputStream);
        this.pollSettings.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getBlackoutByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.parser.writeHeader(byteArrayOutputStream);
        this.writeUnknownChunks(byteArrayOutputStream, this.unknownBlackoutChunks);
        this.writeBlackoutUsage(byteArrayOutputStream);
        this.writeProtocol(byteArrayOutputStream);
        this.pollBlackout.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public long getNextEvent() throws Exception {
        long l = 0L;
        switch (this.selectedSchedule) {
            case 1: {
                l = this.pollPeriodic.getNextEvent();
                break;
            }
            case 2: {
                l = this.pollDaily.getNextEvent();
                break;
            }
            case 3: {
                l = this.pollWeekly.getNextEvent();
            }
        }
        return l;
    }

    public boolean inBlackout() {
        int n;
        int n2;
        int n3;
        int n4;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (this.time != 0L) {
            gregorianCalendar.setTime(new Date(this.time));
        }
        return this.pollBlackout.findEndOfBlackout(n4 = gregorianCalendar.get(7) - 1, n3 = (n2 = gregorianCalendar.get(11)) * 60 + (n = gregorianCalendar.get(12))) != 0;
    }

    class OctetStreamParser {
        public static final byte CTYPE_PERIODIC = 80;
        public static final byte CTYPE_DAILY = 68;
        public static final byte CTYPE_WEEKLY = 87;
        public static final byte CTYPE_BLACKOUT = 66;
        public static final byte CTYPE_SELECT = 83;
        public static final byte CTYPE_USAGE = 85;
        public static final byte CTYPE_PROTOCOL = 112;
        public static final byte CTYPE_POLL_SETTINGS = 115;
        private final byte[] SIGNATURE = new byte[]{71, 87, 83, 67, 72};
        private final int SIG_UNSUSED = 15;
        private int majorVersion = 0;
        private int minorVersion = 1;
        private int ticksPerDay = 48;

        OctetStreamParser() {
        }

        public short uByteToShort(byte by) {
            return (short)((char)by & 0xFF);
        }

        public int getInt(byte[] byArray) {
            return this.getInt(byArray, 0);
        }

        public int getInt(byte[] byArray, int n) {
            int n2 = this.uByteToShort(byArray[n]);
            n2 += this.uByteToShort(byArray[1 + n]) << 8;
            n2 += this.uByteToShort(byArray[2 + n]) << 16;
            return n2 += this.uByteToShort(byArray[3 + n]) << 24;
        }

        public int getTicksPerDay() {
            return this.ticksPerDay;
        }

        public byte[] getIntByteArray(int n) {
            byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)((n & 0xFF00) >> 8), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF000000) >> 24)};
            return byArray;
        }

        public byte[] createChunk(byte by, byte[] byArray) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(by);
            byte[] byArray2 = this.getIntByteArray(byArray.length);
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(byArray);
            return byteArrayOutputStream.toByteArray();
        }

        public void parseHeader(ByteArrayInputStream byteArrayInputStream) throws IOException {
            int n = this.SIGNATURE.length;
            byte[] byArray = new byte[n];
            byteArrayInputStream.read(byArray, 0, n);
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == this.SIGNATURE[i]) continue;
                throw new IOException("Invalid schedule header");
            }
            byArray = new byte[4];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            this.majorVersion = this.getInt(byArray);
            byteArrayInputStream.read(byArray, 0, byArray.length);
            this.minorVersion = this.getInt(byArray);
            byteArrayInputStream.read(byArray, 0, byArray.length);
            this.ticksPerDay = this.getInt(byArray);
            byteArrayInputStream.skip(15L);
        }

        public void writeHeader(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            for (int i = 0; i < this.SIGNATURE.length; ++i) {
                byteArrayOutputStream.write(this.SIGNATURE[i]);
            }
            byte[] byArray = this.getIntByteArray(this.majorVersion);
            byteArrayOutputStream.write(byArray);
            byArray = this.getIntByteArray(this.minorVersion);
            byteArrayOutputStream.write(byArray);
            byArray = this.getIntByteArray(this.ticksPerDay);
            byteArrayOutputStream.write(byArray);
            byArray = new byte[15];
            byteArrayOutputStream.write(byArray);
        }

        public byte[] readUnknownChunk(ByteArrayInputStream byteArrayInputStream) throws IOException {
            byte[] byArray = new byte[4];
            byteArrayInputStream.read(byArray, 0, 4);
            int n = this.getInt(byArray);
            byte[] byArray2 = new byte[n];
            byteArrayInputStream.read(byArray2, 0, byArray2.length);
            return byArray2;
        }
    }

    class UnknownChunk {
        byte type;
        byte[] data;

        UnknownChunk(byte by, byte[] byArray) {
            this.type = by;
            this.data = byArray;
        }
    }

    class PollSettings {
        long time = 0L;
        int retries = 1;
        int timeout = 10;
        int escalate = 0;
        int alertDeferral = 0;

        PollSettings() {
        }

        public int getRetries() {
            return this.retries;
        }

        public void setRetries(int n) {
            this.retries = n;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int n) {
            this.timeout = n;
        }

        public int getEscalate() {
            return this.escalate;
        }

        public void setEscalate(int n) {
            this.escalate = n;
        }

        public int getAlertDeferral() {
            return this.alertDeferral;
        }

        public void setAlertDeferral(int n) {
            this.alertDeferral = n;
        }

        public void setValue(ByteArrayInputStream byteArrayInputStream) {
            byteArrayInputStream.skip(4L);
            byte[] byArray = new byte[16];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            this.retries = BlackoutSchedule.this.parser.getInt(byArray);
            this.timeout = BlackoutSchedule.this.parser.getInt(byArray, 4);
            this.escalate = BlackoutSchedule.this.parser.getInt(byArray, 8);
            this.alertDeferral = BlackoutSchedule.this.parser.getInt(byArray, 12);
        }

        public void write(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byte[] byArray = BlackoutSchedule.this.parser.getIntByteArray(this.retries);
            byteArrayOutputStream2.write(byArray);
            byArray = BlackoutSchedule.this.parser.getIntByteArray(this.timeout);
            byteArrayOutputStream2.write(byArray);
            byArray = BlackoutSchedule.this.parser.getIntByteArray(this.escalate);
            byteArrayOutputStream2.write(byArray);
            byArray = BlackoutSchedule.this.parser.getIntByteArray(this.alertDeferral);
            byteArrayOutputStream2.write(byArray);
            OctetStreamParser octetStreamParser = BlackoutSchedule.this.parser;
            BlackoutSchedule.this.parser;
            byArray = octetStreamParser.createChunk((byte)115, byteArrayOutputStream2.toByteArray());
            byteArrayOutputStream.write(byArray);
        }
    }

    class PollBlackout {
        private long time = System.currentTimeMillis();
        int[][] blackout;

        public PollBlackout() {
            this.reset();
        }

        private void reset() {
            this.blackout = new int[7][];
            for (int i = 0; i < 7; ++i) {
                this.blackout[i] = new int[0];
            }
        }

        public void setValue(ByteArrayInputStream byteArrayInputStream) {
            this.reset();
            int n = 4;
            byteArrayInputStream.skip(4L);
            int n2 = byteArrayInputStream.read();
            for (int i = 0; i < n2; ++i) {
                int n3 = byteArrayInputStream.read();
                int n4 = byteArrayInputStream.read();
                this.blackout[n3] = new int[2 * n4];
                for (int j = 0; j < n4; ++j) {
                    byte[] byArray = new byte[n * 2];
                    byteArrayInputStream.read(byArray, 0, byArray.length);
                    this.blackout[n3][j * 2] = BlackoutSchedule.this.parser.getInt(byArray);
                    this.blackout[n3][j * 2 + 1] = BlackoutSchedule.this.parser.getInt(byArray, n);
                }
            }
        }

        public void setValues(int[][] nArray) {
            this.blackout = new int[7][];
            for (int i = 0; i < 7; ++i) {
                this.blackout[i] = new int[nArray[i].length];
                System.arraycopy(nArray[i], 0, this.blackout[i], 0, nArray[i].length);
            }
        }

        public int[][] getValue() {
            int[][] nArrayArray = new int[7][];
            for (int i = 0; i < 7; ++i) {
                if (this.blackout[i].length > 0) {
                    nArrayArray[i] = new int[this.blackout[i].length];
                    System.arraycopy(this.blackout[i], 0, nArrayArray[i], 0, this.blackout[i].length);
                    continue;
                }
                nArrayArray[i] = new int[0];
            }
            return nArrayArray;
        }

        private void write(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            int n;
            int n2 = 1;
            int n3 = 1;
            int n4 = 0;
            BlackoutSchedule.this.parser;
            byteArrayOutputStream.write(66);
            int n5 = 1;
            for (int i = 0; i < 7; ++i) {
                n = this.blackout[i].length;
                if (n <= 0) continue;
                ++n4;
                n5 += n * 4;
                n5 += n2 + n3;
            }
            byte[] byArray = BlackoutSchedule.this.parser.getIntByteArray(n5);
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write((byte)n4);
            for (n = 0; n < 7; ++n) {
                if (this.blackout[n].length == 0) continue;
                byteArrayOutputStream.write((byte)n);
                byteArrayOutputStream.write((byte)(this.blackout[n].length / 2));
                for (int i = 0; i < this.blackout[n].length; ++i) {
                    byArray = BlackoutSchedule.this.parser.getIntByteArray(this.blackout[n][i]);
                    byteArrayOutputStream.write(byArray);
                }
            }
        }

        public int findEndOfBlackout(int n, int n2) {
            int n3 = 0;
            if (BlackoutSchedule.this.blackoutUsage != 3) {
                int n4 = BlackoutSchedule.this.parser.getTicksPerDay();
                int n5 = n4 / 24;
                int n6 = 60 / n5;
                boolean bl = false;
                int[] nArray = this.blackout[n];
                for (int i = 0; i < nArray.length; i += 2) {
                    if (n2 < nArray[i] * n6 || n2 >= nArray[i + 1] * n6) continue;
                    bl = true;
                    n3 = nArray[i + 1] * n6;
                    break;
                }
            }
            return n3;
        }

        public void dumpBlackout() {
            if (Debug.trace) {
                Debug.trace((String)"\nBlackout:");
                Debug.trace((String)("usage = " + BlackoutSchedule.this.blackoutUsage));
                for (int i = 0; i < this.blackout.length; ++i) {
                    Debug.trace((String)("day = " + i));
                    for (int j = 0; j < this.blackout[i].length; j += 2) {
                        Debug.trace((String)("start = " + this.blackout[i][j] + " end " + this.blackout[i][j + 1]));
                    }
                }
                Debug.trace((String)"");
            }
        }
    }

    class PollWeekly {
        SmartBits[] bits = new SmartBits[7];

        public PollWeekly() {
            for (int i = 0; i < 7; ++i) {
                this.bits[i] = new SmartBits();
            }
        }

        public void setValue(ByteArrayInputStream byteArrayInputStream) {
            byte[] byArray = new byte[4];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            int n = BlackoutSchedule.this.parser.getInt(byArray);
            byArray = new byte[n /= 7];
            for (int i = 0; i < 7; ++i) {
                byteArrayInputStream.read(byArray, 0, byArray.length);
                this.bits[i] = new SmartBits();
                this.bits[i].setValue(byArray);
            }
        }

        public void setValue(SmartBits[] smartBitsArray) {
            for (int i = 0; i < smartBitsArray.length; ++i) {
                this.bits[i] = (SmartBits)smartBitsArray[i].clone();
            }
        }

        public byte[] getByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (int i = 0; i < this.bits.length; ++i) {
                byte[] byArray = this.bits[i].getByteArray();
                byteArrayOutputStream.write(byArray);
            }
            return byteArrayOutputStream.toByteArray();
        }

        private void write(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            byte[] byArray = this.getByteArray();
            OctetStreamParser octetStreamParser = BlackoutSchedule.this.parser;
            BlackoutSchedule.this.parser;
            byArray = octetStreamParser.createChunk((byte)87, byArray);
            byteArrayOutputStream.write(byArray);
        }

        public SmartBits[] getValue() {
            SmartBits[] smartBitsArray = new SmartBits[7];
            for (int i = 0; i < 7; ++i) {
                smartBitsArray[i] = (SmartBits)this.bits[i].clone();
            }
            return smartBitsArray;
        }

        public long getNextEvent() {
            int n;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (BlackoutSchedule.this.time != 0L) {
                gregorianCalendar.setTime(new Date(BlackoutSchedule.this.time));
            }
            int n2 = gregorianCalendar.get(11);
            int n3 = gregorianCalendar.get(12);
            int n4 = n2 * 60 + n3;
            int n5 = BlackoutSchedule.this.parser.getTicksPerDay();
            int n6 = n5 / 24;
            int n7 = 1440;
            int n8 = n7 / n5;
            int n9 = n2 * n6 + n3 / n8;
            int n10 = 0;
            int n11 = gregorianCalendar.get(7) - 1;
            int n12 = -1;
            int n13 = n9;
            while (n10 <= 7) {
                if ((n13 = this.bits[n10 + n11].getNextBit(n13, false)) == -1 || n12 >= n13) {
                    if (++n10 + n11 == 7) {
                        n11 -= 7;
                    }
                    n12 = -1;
                    n13 = 0;
                    continue;
                }
                if (n13 == -1) continue;
                n12 = n13;
                n = BlackoutSchedule.this.pollBlackout.findEndOfBlackout(n10 + n11, n13 * n8);
                if (n == 0) break;
                n13 = n / n8;
                if (n13 > n5) {
                    ++n10;
                    n13 -= n5;
                }
                if (n10 + n11 != 7) continue;
                n11 -= 7;
            }
            if (n10 > 7) {
                throw new RuntimeException("No scheduled events found");
            }
            n = n10 * 24;
            int n14 = n13 * n8 - n4;
            return (long)n * 3600000L + (long)n14 * 60000L;
        }
    }

    class PollDaily {
        private SmartBits bits = new SmartBits();

        public void setValue(ByteArrayInputStream byteArrayInputStream) {
            byte[] byArray = new byte[4];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            int n = BlackoutSchedule.this.parser.getInt(byArray);
            byArray = new byte[n];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            this.bits.setValue(byArray);
        }

        public void setValue(SmartBits smartBits) {
            this.bits = (SmartBits)smartBits.clone();
        }

        public byte[] getByteArray() {
            return this.bits.getByteArray();
        }

        private void write(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            byte[] byArray = this.getByteArray();
            OctetStreamParser octetStreamParser = BlackoutSchedule.this.parser;
            BlackoutSchedule.this.parser;
            byArray = octetStreamParser.createChunk((byte)68, byArray);
            byteArrayOutputStream.write(byArray);
        }

        public SmartBits getValue() {
            return (SmartBits)this.bits.clone();
        }

        public long getNextEvent() throws Exception {
            int n;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (BlackoutSchedule.this.time != 0L) {
                gregorianCalendar.setTime(new Date(BlackoutSchedule.this.time));
            }
            int n2 = gregorianCalendar.get(11);
            int n3 = gregorianCalendar.get(12);
            int n4 = n2 * 60 + n3;
            int n5 = BlackoutSchedule.this.parser.getTicksPerDay();
            int n6 = n5 / 24;
            int n7 = 1440;
            int n8 = n7 / n5;
            int n9 = n2 * n6 + n3 / n8;
            int n10 = 0;
            int n11 = gregorianCalendar.get(7) - 1;
            int n12 = -1;
            int n13 = n9;
            while (n10 <= 7) {
                if ((n13 = this.bits.getNextBit(n13, false)) == -1 || n12 >= n13) {
                    if (++n10 + n11 == 7) {
                        n11 -= 7;
                    }
                    n12 = -1;
                    n13 = 0;
                    continue;
                }
                if (n13 == -1) continue;
                n12 = n13;
                n = BlackoutSchedule.this.pollBlackout.findEndOfBlackout(n10 + n11, n13 * n8);
                if (n == 0) break;
                n13 = n / n8;
                if (n13 > n5) {
                    ++n10;
                    n13 -= n5;
                }
                if (n10 + n11 != 7) continue;
                n11 -= 7;
            }
            if (n10 > 7) {
                throw new RuntimeException("No scheduled events found");
            }
            n = n10 * 24;
            int n14 = n13 * n8 - n4;
            return (long)n * 3600000L + (long)n14 * 60000L;
        }
    }

    class PollPeriodic {
        private int hours = 0;
        private int minutes = 5;

        public int getHours() {
            return this.hours;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public void setHours(int n) {
            this.hours = n;
        }

        public void setMinutes(int n) {
            this.minutes = n;
        }

        public void setValue(ByteArrayInputStream byteArrayInputStream) {
            byteArrayInputStream.skip(4L);
            byte[] byArray = new byte[8];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            this.hours = BlackoutSchedule.this.parser.getInt(byArray);
            this.minutes = BlackoutSchedule.this.parser.getInt(byArray, 4);
        }

        public void writePeriodic(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            byte[] byArray = BlackoutSchedule.this.parser.getIntByteArray(this.hours);
            byteArrayOutputStream2.write(byArray);
            byArray = BlackoutSchedule.this.parser.getIntByteArray(this.minutes);
            byteArrayOutputStream2.write(byArray);
            OctetStreamParser octetStreamParser = BlackoutSchedule.this.parser;
            BlackoutSchedule.this.parser;
            byArray = octetStreamParser.createChunk((byte)80, byteArrayOutputStream2.toByteArray());
            byteArrayOutputStream.write(byArray);
        }

        public long getNextEvent() throws Exception {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            if (BlackoutSchedule.this.time != 0L) {
                gregorianCalendar.setTime(new Date(BlackoutSchedule.this.time));
            }
            int n = gregorianCalendar.get(7) - 1;
            int n2 = gregorianCalendar.get(11);
            int n3 = gregorianCalendar.get(12);
            int n4 = this.hours * 60 + this.minutes;
            int n5 = n2 * 60 + n3;
            int n6 = n2 * 60 + n3 + n4;
            int n7 = BlackoutSchedule.this.pollBlackout.findEndOfBlackout(n, n6);
            long l = n7 == 0 ? (long)n4 : (long)(n7 - n5);
            return l * 60000L;
        }
    }
}

