/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.util.SafePopupMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ButtonMenu
extends JButton
implements ActionListener,
MouseListener {
    private SafePopupMenu menu = new SafePopupMenu((Component)this);
    private int selection = -1;
    private static final int triWidth = 13;
    private static final int triHeight = 7;
    private boolean pressed = false;
    private boolean entered = false;

    public ButtonMenu() {
        this.addActionListener(this);
        this.addMouseListener(this);
    }

    public ButtonMenu(JMenuItem[] jMenuItemArray, int n) {
        this();
        this.selection = n;
        if (jMenuItemArray != null) {
            this.addMenuItems(jMenuItemArray);
        }
        if (this.selection != -1) {
            JMenuItem jMenuItem = (JMenuItem)this.menu.getComponent(this.selection);
            this.setText(jMenuItem.getText());
        }
    }

    public void addMenuItems(JMenuItem[] jMenuItemArray) {
        for (int i = 0; i < jMenuItemArray.length; ++i) {
            this.addMenuItem(jMenuItemArray[i]);
        }
    }

    public void addMenuItems(SafePopupMenu safePopupMenu) {
        this.menu = safePopupMenu;
    }

    public void addMenuItem(JMenuItem jMenuItem) {
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        this.menu.pack();
    }

    public void setPrefSize() {
        Serializable serializable;
        int n;
        int n2 = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        MenuElement[] menuElementArray = this.menu.getSubElements();
        for (n = 0; n < menuElementArray.length; ++n) {
            serializable = (JMenuItem)menuElementArray[n].getComponent();
            int n3 = fontMetrics.stringWidth(serializable.getText());
            if (n3 <= n2) continue;
            n2 = n3;
        }
        n = this.getMargin().left + this.getMargin().right;
        serializable = this.getPreferredSize();
        this.setPreferredSize(new Dimension(n2 + n, ((Dimension)serializable).height));
    }

    public void resetMenu() {
        this.menu.removeAll();
    }

    public void setBorder(Border border) {
        super.setBorder(new CompoundBorder(border, new EmptyBorder(0, 0, 0, 13)));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        Polygon polygon = new Polygon();
        Insets insets = this.getBorder().getBorderInsets(this);
        int n = this.getHeight() / 2 - 3;
        int n2 = this.getWidth() - insets.right + 4;
        if (this.pressed && this.entered) {
            ++n2;
            ++n;
        }
        polygon.addPoint(n2, n);
        polygon.addPoint(n2 + 13, n);
        polygon.addPoint(n2 + 6, n + 7);
        graphics.fillPolygon(polygon);
        graphics.setColor(color);
    }

    public void setSelectedIndex(int n) {
        String string = "";
        this.selection = n;
        if (this.selection != -1) {
            Component component = this.menu.getComponent(this.selection);
            if (component instanceof JMenuItem) {
                string = ((JMenuItem)component).getText();
            }
            this.setText(string);
        }
    }

    public void setSelectedItem(String string) {
        boolean bl = false;
        MenuElement[] menuElementArray = this.menu.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            String string2 = "";
            Component component = menuElementArray[i].getComponent();
            if (!(component instanceof JCheckBoxMenuItem) || !string.equals(string2 = ((JCheckBoxMenuItem)component).getText())) continue;
            this.selection = i;
            bl = true;
            this.setText(string2);
            break;
        }
        if (!bl) {
            throw new RuntimeException(string + " is not found in this menu item");
        }
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            if (object instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)this.menu.getComponent(this.selection)).setState(false);
            }
            this.selection = this.menu.getComponentIndex((Component)jMenuItem);
            this.setText(jMenuItem.getText());
        } else {
            if (this.menu.getSubElements().length > 0 && this.selection == -1) {
                this.selection = 0;
            }
            if (this.selection != -1 && (object = this.menu.getComponent(this.selection)) != null && object instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)object).setState(true);
            }
            if (this.menu.getSize().height == 0) {
                this.menu.setVisible(true);
                this.menu.setVisible(false);
            }
            Rectangle rectangle = this.computePopupBounds(0, this.getBounds().height, this.menu.getSize().width, this.menu.getSize().height);
            this.menu.show((Component)this, rectangle.x, rectangle.y);
            if (this.selection != -1) {
                this.menu.getSelectionModel().setSelectedIndex(this.selection);
                this.menu.invalidate();
                this.menu.paint(this.menu.getGraphics());
            }
        }
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Cloneable cloneable;
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        Dialog dialog = SafePopupMenu.getDialog((Component)this);
        if (dialog != null) {
            if (dialog instanceof JDialog) {
                JRootPane jRootPane = ((JDialog)dialog).getRootPane();
                cloneable = jRootPane.getLocationOnScreen();
                rectangle = jRootPane.getBounds();
                rectangle.x = cloneable.x;
                rectangle.y = cloneable.y;
            } else {
                rectangle = dialog.getBounds();
            }
            cloneable = new Point(rectangle.x, rectangle.y);
            SwingUtilities.convertPointFromScreen(cloneable, this);
            rectangle.x = cloneable.x;
            rectangle.y = cloneable.y;
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle = new Rectangle();
            cloneable = new Point(0, 0);
            SwingUtilities.convertPointFromScreen(cloneable, this);
            rectangle.x = cloneable.x;
            rectangle.y = cloneable.y;
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
        }
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, rectangle2)) {
            return rectangle2;
        }
        cloneable = new Rectangle(0, -rectangle2.height, rectangle2.width, rectangle2.height);
        if (SwingUtilities.isRectangleContainingRectangle(rectangle, (Rectangle)cloneable)) {
            return cloneable;
        }
        if (dialog != null) {
            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
            SwingUtilities.computeIntersection(rectangle.x, rectangle.y, rectangle.width, rectangle.height, (Rectangle)cloneable);
            if (rectangle2.height > ((Rectangle)cloneable).height) {
                return rectangle2;
            }
            return cloneable;
        }
        return cloneable;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.entered = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.entered = false;
    }
}

