/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class GWBorder {
    public static final Border NO_BORDER = new EmptyBorder(1, 1, 1, 1);
    public static final Border LOWERED_BORDER = new LoweredBorder();
    public static final Border RAISED_BORDER = new RaisedBorder();
    private static Color darkColor;

    private static Color getDarkColor() {
        if (darkColor == null) {
            darkColor = (Color)UIManager.getDefaults().get("Button.background");
            darkColor = darkColor == null ? Color.DARK_GRAY : darkColor.darker();
        }
        return darkColor;
    }

    public static class LoweredBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }
    }

    public static class RaisedBorder
    extends AbstractBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.WHITE);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.setColor(GWBorder.getDarkColor());
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n, n2 + n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }
    }
}

