/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.widgets.DontChangeMyFont;
import com.novell.gw.admin.widgets.EditField;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.util.Debug;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IPEditor
extends JComponent
implements ChangeListener,
SwingConstants {
    private static final int defaultHeight = new JTextField().getPreferredSize().height;
    private static final Dimension DEFAULT_SIZE = new Dimension(46, defaultHeight);
    private IPEditField[] fields = new IPEditField[4];
    private DotLabel[] dots = new DotLabel[3];
    private ChangeEvent changeEvent = null;
    private char[] tabChars = new char[]{'.'};
    private char[] validChars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    private static Font dotFont = new Font("Dialog", 1, 14);
    private int minFieldWidth = 0;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public IPEditor() {
        this.setLayout(new BoxLayout(this, 0){

            public float getLayoutAlignmentX(Container container) {
                return 0.0f;
            }

            public float getLayoutAlignmentY(Container container) {
                return 0.0f;
            }
        });
        this.fields[0] = this.getEditField();
        this.add(this.fields[0]);
        NConeFactory.novellJTextField((JTextField)this.fields[0], (String)RB.getString("firstOctet"), (String)"This is a textfield");
        this.dots[0] = new DotLabel();
        this.add(this.dots[0]);
        this.fields[1] = this.getEditField();
        this.add(this.fields[1]);
        NConeFactory.novellJTextField((JTextField)this.fields[1], (String)RB.getString("secondOctet"), (String)"This is a textfield");
        this.dots[1] = new DotLabel();
        this.add(this.dots[1]);
        this.fields[2] = this.getEditField();
        this.add(this.fields[2]);
        NConeFactory.novellJTextField((JTextField)this.fields[2], (String)RB.getString("thirdOctet"), (String)"This is a textfield");
        this.dots[2] = new DotLabel();
        this.add(this.dots[2]);
        this.fields[3] = this.getEditField();
        this.add(this.fields[3]);
        NConeFactory.novellJTextField((JTextField)this.fields[3], (String)RB.getString("fourthOctet"), (String)"This is a textfield");
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setTabChars(this.tabChars);
            this.fields[i].setMaxLength(3);
            this.fields[i].addChangeListener(this);
            this.fields[i].setValidChars(this.validChars);
        }
        this.enableEvents(4L);
    }

    public void print() {
        for (int i = 0; i < this.fields.length; ++i) {
            System.out.println(i + " size: " + this.fields[i].getSize());
        }
    }

    private IPEditField getEditField() {
        IPEditField iPEditField = new IPEditField();
        iPEditField.setHorizontalAlignment(0);
        iPEditField.setMaximumSize(DEFAULT_SIZE);
        if (this.minFieldWidth == 0) {
            this.minFieldWidth = 32;
        }
        if (this.minFieldWidth != 0) {
            Dimension dimension = new Dimension(this.minFieldWidth, defaultHeight);
            iPEditField.setMinimumSize(dimension);
            iPEditField.setPreferredSize(dimension);
        }
        return iPEditField;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = IPEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = IPEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? IPEditor.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004) {
            IPEditField iPEditField = this.fields[0];
            iPEditField.requestFocus();
        }
    }

    public void setEnabled(boolean bl) {
        int n;
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n].setEnabled(bl);
        }
        for (n = 0; n < this.dots.length; ++n) {
            this.dots[n].setEnabled(bl);
        }
    }

    public int setValue(String string) {
        if (Debug.trace) {
            Debug.trace((String)("IPEditor.setValue: str=[" + string + "]"));
        }
        if (string == null) {
            if (Debug.trace) {
                Debug.trace((String)"                       *** IPEditor.setValue: do nothing with NULL.");
            }
            return 1;
        }
        if (string.length() < 7) {
            if (Debug.trace) {
                Debug.trace((String)("                       *** IPEditor.setValue: INVALID " + string + "- do nothing"));
            }
            return 2;
        }
        int n = 0;
        for (int i = 0; i < this.fields.length; ++i) {
            int n2 = string.indexOf(46, n);
            if (n2 == -1) {
                if (i == this.fields.length - 1) {
                    n2 = string.length();
                } else {
                    if (Debug.trace) {
                        Debug.trace((String)("                       *** IPEditor.setValue: INVALID " + string + "- bailing out"));
                    }
                    return 3;
                }
            }
            this.fields[i].setText(string.substring(n, n2));
            n = n2 + 1;
        }
        return 0;
    }

    public String getValue() {
        String string = new String();
        for (int i = 0; i < this.fields.length; ++i) {
            String string2 = new String();
            String string3 = this.fields[i].getText();
            string2 = i == this.fields.length - 1 ? "" : ".";
            if (string3.length() <= 0) continue;
            string = string.concat(string3 + string2);
        }
        return new String(string);
    }

    public boolean isValueValid() {
        for (int i = 0; i < this.fields.length; ++i) {
            String string = this.fields[i].getText();
            if (string == null || string.length() == 0) {
                return false;
            }
            try {
                int n = Integer.valueOf(string);
                if (n >= 0 && n <= 255) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                if (Debug.trace) {
                    Debug.trace((String)("    *** IPEditor.isValueValid: Non-numeric string [" + string + "]"));
                }
                return false;
            }
        }
        return true;
    }

    public void setFieldSizes(Dimension dimension) {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setMaximumSize(dimension);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IPEditField
    extends EditField {
        private IPEditField() {
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (keyEvent.getID() == 400) {
                if (this.isCharValid(c)) {
                    int n = this.getSelectionEnd() - this.getSelectionStart();
                    if (n == 0 && c != '\b') {
                        int n2 = this.getDocument().getLength();
                        if (this.maxLength != this.NO_MAX && n2 >= this.maxLength) {
                            keyEvent.consume();
                            this.getToolkit().beep();
                        } else if (n2 == this.maxLength - 1 && this.okToTransferFocus) {
                            this.transferFocus();
                        }
                    }
                    super.processKeyEvent(keyEvent);
                } else {
                    keyEvent.consume();
                    boolean bl = true;
                    for (int i = 0; i < this.tabChars.length; ++i) {
                        if (c != this.tabChars[i]) continue;
                        if (this.okToTransferFocus && this.getText().length() > 0) {
                            this.transferFocus();
                        }
                        bl = false;
                        break;
                    }
                    if (bl) {
                        this.getToolkit().beep();
                    }
                }
            } else {
                super.processKeyEvent(keyEvent);
            }
        }
    }

    class DotLabel
    extends JLabel
    implements DontChangeMyFont {
        DotLabel() {
            super(" . ");
            this.setFont(dotFont);
            this.setVerticalAlignment(3);
        }
    }
}

