/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.utility.localization.Loc;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ListCheckBox
extends JPanel
implements ItemSelectable,
ItemListener {
    private static final Color HIGHLIGHT = Color.blue.darker().darker();
    private boolean selected = false;
    private boolean enabled = true;
    private JCheckBox checkBox;
    private JLabel label;
    private Object model;
    private ItemListener itemListener;

    public ListCheckBox() {
        this.initComponents();
        this.setOpaque(false);
        this.setBackground(HIGHLIGHT);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.checkBox.addItemListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.checkBox, gridBagConstraints);
        this.label = new JLabel();
        this.label.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.label, gridBagConstraints);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.selected) {
            return new Object[]{this.label.getText()};
        }
        return null;
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.selected) {
            this.setSelected(false);
        }
        this.checkBox.setEnabled(bl);
        this.label.setEnabled(bl);
    }

    public String getText() {
        return this.label.getText();
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object object) {
        this.model = object;
        this.label.setText(object.toString());
        NConeFactory.novellJCheckBox((JCheckBox)this.checkBox, (String)Loc.removeHotChar((String)object.toString()), (String)"");
    }

    public void setText(String string) {
        this.label.setText(string);
        NConeFactory.novellJCheckBox((JCheckBox)this.checkBox, (String)Loc.removeHotChar((String)string), (String)"");
    }

    public void updateLabel() {
        this.label.setText(this.model.toString());
    }

    public boolean isChecked() {
        return this.checkBox.isSelected();
    }

    public void setChecked(boolean bl) {
        this.checkBox.setSelected(bl);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        if (bl) {
            this.setOpaque(true);
            this.label.setForeground(Color.white);
        } else {
            this.setOpaque(false);
            this.label.setForeground(Color.black);
        }
        this.repaint();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            ItemEvent itemEvent2 = new ItemEvent(this, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange());
            this.itemListener.itemStateChanged(itemEvent2);
        }
    }
}

