/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.ListCheckBox;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MultipleCheckBoxList
extends JPanel
implements MouseListener,
ItemSelectable {
    public static final int ORDER_ALPHANUMERIC = 0;
    public static final int ORDER_GIVEN = 1;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    public static final String DOUBLE_CLICK = "DOUBLE CLICK";
    private static final GridBagConstraints springGbc = new GridBagConstraints();
    private static final GridBagConstraints lcbGbc;
    private final Component spring = Box.createGlue();
    private boolean enabled = true;
    private boolean checkingEnabled = true;
    private int order = 0;
    private int selectionMode = 1;
    private ActionListener actionListeners;
    private ItemListener itemListeners;

    public MultipleCheckBoxList() {
        this.init();
    }

    public MultipleCheckBoxList(int n) {
        this.order = n;
        this.init();
    }

    private void init() {
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.add(this.spring, springGbc);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListeners = AWTEventMulticaster.add(this.actionListeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListeners = AWTEventMulticaster.remove(this.actionListeners, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, itemListener);
    }

    private void setupNewLcb(ListCheckBox listCheckBox) {
        listCheckBox.setEnabled(this.enabled && this.checkingEnabled);
        listCheckBox.addMouseListener(this);
    }

    public void add(ListCheckBox listCheckBox) {
        this.addAlphaCheckBox(listCheckBox);
    }

    public int addAlphaCheckBox(ListCheckBox listCheckBox) {
        int n = -1;
        this.setupNewLcb(listCheckBox);
        int n2 = this.getComponentCount() - 1;
        if (this.order == 0) {
            String string = listCheckBox.getText();
            if (string == null) {
                n = 0;
            } else {
                ListCheckBox listCheckBox2;
                String string2;
                for (n = 0; n < n2 && ((string2 = (listCheckBox2 = (ListCheckBox)this.getComponent(n)).getText()) == null || string.compareToIgnoreCase(string2) >= 0); ++n) {
                }
            }
        } else {
            n = n2;
        }
        this.add(listCheckBox, lcbGbc, n);
        this.revalidate();
        return n;
    }

    public void add(ListCheckBox listCheckBox, int n) {
        if (this.order != 0) {
            this.setupNewLcb(listCheckBox);
            int n2 = this.getCheckBoxCount();
            if (n > n2) {
                n = n2;
            }
            if (n >= 0) {
                this.add(listCheckBox, lcbGbc, n);
                this.revalidate();
            }
        }
    }

    public void remove(int n) {
        ListCheckBox listCheckBox = this.getListCheckBox(n);
        if (listCheckBox != null) {
            this.remove(listCheckBox, n);
        }
    }

    public void remove(ListCheckBox listCheckBox) {
        int n = this.indexForLcb(listCheckBox);
        if (n != -1) {
            this.remove(listCheckBox, n);
        }
    }

    private void remove(ListCheckBox listCheckBox, int n) {
        listCheckBox.removeMouseListener(this);
        super.remove(n);
        this.revalidate();
    }

    public void labelChanged(ListCheckBox listCheckBox) {
        int n = this.indexForLcb(listCheckBox);
        if (n != -1) {
            listCheckBox.updateLabel();
            if (this.order == 0) {
                String string;
                int n2;
                ListCheckBox listCheckBox2;
                Object object;
                String string2 = listCheckBox.getText();
                boolean bl = false;
                if (n > 0 && string2.compareToIgnoreCase((String)(object = (listCheckBox2 = (ListCheckBox)this.getComponent(n - 1)).getText())) < 0) {
                    bl = true;
                }
                if (n < (n2 = this.getComponentCount() - 1) - 1 && string2.compareToIgnoreCase(string = ((ListCheckBox)(object = (ListCheckBox)this.getComponent(n + 1))).getText()) > 0) {
                    bl = true;
                }
                if (bl) {
                    boolean bl2 = listCheckBox.isSelected();
                    this.remove(listCheckBox);
                    this.add(listCheckBox);
                    listCheckBox.setSelected(bl2);
                }
            }
        }
    }

    public int indexForLcb(ListCheckBox listCheckBox) {
        int n = this.getComponentCount() - 1;
        for (int i = 0; i < n; ++i) {
            if (listCheckBox != this.getComponent(i)) continue;
            return i;
        }
        return -1;
    }

    public int getCheckBoxCount() {
        return this.getComponentCount() - 1;
    }

    public ListCheckBox getListCheckBox(int n) {
        ListCheckBox listCheckBox = null;
        if (n >= 0 && n < this.getCheckBoxCount()) {
            listCheckBox = (ListCheckBox)this.getComponent(n);
        }
        return listCheckBox;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCheckingEnabled(boolean bl) {
        if (!this.enabled) {
            return;
        }
        this.setAllLcbsEnabled(bl);
        this.checkingEnabled = bl;
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.deselectAll();
        }
        this.setAllLcbsEnabled(bl);
        this.enabled = bl;
        this.checkingEnabled = bl;
    }

    public void setAllLcbsEnabled(boolean bl) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            component.setEnabled(bl);
        }
    }

    public int getMinSelectionIndex() {
        for (int i = 0; i < this.getCheckBoxCount(); ++i) {
            ListCheckBox listCheckBox = this.getListCheckBox(i);
            if (!listCheckBox.isSelected()) continue;
            return i;
        }
        return -1;
    }

    public int getMaxSelectionIndex() {
        for (int i = this.getCheckBoxCount() - 1; i >= 0; --i) {
            ListCheckBox listCheckBox = this.getListCheckBox(i);
            if (!listCheckBox.isSelected()) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelectedIndex(int n) {
        boolean bl = false;
        ListCheckBox listCheckBox = this.getListCheckBox(n);
        if (listCheckBox != null) {
            bl = listCheckBox.isSelected();
        }
        return bl;
    }

    public int getCheckedCount() {
        int n = 0;
        int n2 = this.getCheckBoxCount();
        for (int i = 0; i < n2; ++i) {
            ListCheckBox listCheckBox = this.getListCheckBox(i);
            if (!listCheckBox.isChecked()) continue;
            ++n;
        }
        return n;
    }

    public int getSelectedCount() {
        int n = 0;
        int n2 = this.getCheckBoxCount();
        for (int i = 0; i < n2; ++i) {
            ListCheckBox listCheckBox = this.getListCheckBox(i);
            if (!listCheckBox.isSelected()) continue;
            ++n;
        }
        return n;
    }

    public Object[] getSelectedObjects() {
        Vector<ListCheckBox> vector = new Vector<ListCheckBox>();
        for (int i = 0; i < this.getCheckBoxCount(); ++i) {
            ListCheckBox listCheckBox = this.getListCheckBox(i);
            if (!listCheckBox.isSelected()) continue;
            vector.addElement(listCheckBox);
        }
        return vector.toArray();
    }

    public void deselectAll() {
        for (int i = 0; i < this.getCheckBoxCount(); ++i) {
            ListCheckBox listCheckBox = this.getListCheckBox(i);
            if (!listCheckBox.isSelected()) continue;
            this.setSelected(false, i);
        }
    }

    public void uncheckAll() {
        for (int i = 0; i < this.getCheckBoxCount(); ++i) {
            ListCheckBox listCheckBox = (ListCheckBox)this.getComponent(i);
            JCheckBox jCheckBox = listCheckBox.getCheckBox();
            if (!jCheckBox.isSelected()) continue;
            jCheckBox.setSelected(false);
        }
    }

    public void removeAll() {
        this.deselectAll();
        super.removeAll();
        this.initComponents();
    }

    public void setSelected(boolean bl, int n) {
        ListCheckBox listCheckBox = this.getListCheckBox(n);
        if (listCheckBox != null) {
            this.setSelected(bl, listCheckBox);
        }
    }

    public void setSelected(boolean bl, ListCheckBox listCheckBox) {
        listCheckBox.setSelected(bl);
        ItemEvent itemEvent = bl ? new ItemEvent(this, 701, listCheckBox, 1) : new ItemEvent(this, 701, listCheckBox, 2);
        if (this.itemListeners != null) {
            this.itemListeners.itemStateChanged(itemEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        if (!this.enabled) {
            return;
        }
        int n = mouseEvent.getClickCount();
        if (n == 2 && (object = mouseEvent.getSource()) instanceof ListCheckBox) {
            ListCheckBox listCheckBox = (ListCheckBox)object;
            this.deselectAll();
            this.setSelected(true, listCheckBox);
            if (this.actionListeners != null) {
                ActionEvent actionEvent = new ActionEvent(listCheckBox, 1001, DOUBLE_CLICK);
                this.actionListeners.actionPerformed(actionEvent);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object instanceof ListCheckBox) {
            ListCheckBox listCheckBox = (ListCheckBox)object;
            if (mouseEvent.isControlDown()) {
                if (this.selectionMode == 0) {
                    this.deselectAll();
                }
                this.setSelected(!listCheckBox.isSelected(), listCheckBox);
            } else {
                this.deselectAll();
                this.setSelected(true, listCheckBox);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        MultipleCheckBoxList.springGbc.gridx = 0;
        MultipleCheckBoxList.springGbc.weightx = 1.0;
        MultipleCheckBoxList.springGbc.weighty = 1.0;
        MultipleCheckBoxList.springGbc.fill = 1;
        lcbGbc = new GridBagConstraints();
        MultipleCheckBoxList.lcbGbc.gridx = 0;
        MultipleCheckBoxList.lcbGbc.weightx = 1.0;
        MultipleCheckBoxList.lcbGbc.fill = 2;
    }
}

