/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.MainShell;
import com.novell.application.console.snapin.Shell;
import com.novell.application.console.snapin.SnapinException;
import com.novell.gw.admin.widgets.GwTable;
import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.WrapLabel;
import com.novell.gw.util.OperationResults;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class OperationResultsDlg
extends JDialog
implements ActionListener,
ListSelectionListener {
    private JButton closeButton;
    private JButton detailsButton;
    private GwTable table;
    private DefaultTableModel tableModel;
    private ListSelectionModel selectionModel;
    private OperationResults opResults;

    public OperationResultsDlg(Frame frame, OperationResults operationResults) {
        super(frame, RB.getString("GWAdmin"), true);
        this.init(operationResults);
    }

    public OperationResultsDlg(Dialog dialog, OperationResults operationResults) {
        super(dialog, RB.getString("GWAdmin"), true);
        this.init(operationResults);
    }

    private void init(OperationResults operationResults) {
        this.opResults = operationResults;
        this.initComponents();
        this.fillFields();
        this.pack();
        this.setSize(600, 300);
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        WrapLabel wrapLabel = new WrapLabel(RB.getString("ErrorsProcessingObjects"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)wrapLabel, gridBagConstraints);
        this.table = GwTable.createResizableTable();
        this.table.getAccessibleContext().setAccessibleName(wrapLabel.getText());
        this.table.setShowGrid(false);
        this.selectionModel = this.table.getSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.closeButton = RB.getUnsizedButton("closeKey");
        this.closeButton.addActionListener(this);
        jPanel.add(this.closeButton);
        this.detailsButton = RB.getUnsizedButton("detailsKey");
        this.detailsButton.setEnabled(false);
        this.detailsButton.addActionListener(this);
        jPanel.add(this.detailsButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        container.add((Component)jPanel, gridBagConstraints);
    }

    private void fillFields() {
        String[] stringArray = this.opResults.getInfoDescriptions();
        Vector vector = this.opResults.getErrors();
        int n = stringArray.length + 1;
        int n2 = vector.size();
        Object[] objectArray = new String[n];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        objectArray[n - 1] = RB.getString("Error");
        this.tableModel = new DefaultTableModel(objectArray, 0);
        this.table.setModel(this.tableModel);
        for (int i = 0; i < n2; ++i) {
            OperationResults.ErrorInfo errorInfo = (OperationResults.ErrorInfo)vector.elementAt(i);
            Object[] objectArray2 = new Object[n];
            System.arraycopy(errorInfo.info, 0, objectArray2, 0, errorInfo.info.length);
            objectArray2[n - 1] = new ExceptionInfo(errorInfo.exception);
            this.tableModel.addRow(objectArray2);
        }
        this.table.sizeColumnsToFitData();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl;
        boolean bl2 = false;
        int n = this.selectionModel.getMinSelectionIndex();
        boolean bl3 = bl = n != -1 && n == this.selectionModel.getMaxSelectionIndex();
        if (bl) {
            int n2 = this.tableModel.getColumnCount() - 1;
            ExceptionInfo exceptionInfo = (ExceptionInfo)this.tableModel.getValueAt(n, n2);
            bl2 = exceptionInfo.supportsHelp();
        }
        this.detailsButton.setEnabled(bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.dispose();
        } else if (object == this.detailsButton) {
            int n = this.table.getSelectedRow();
            int n2 = this.tableModel.getColumnCount() - 1;
            ExceptionInfo exceptionInfo = (ExceptionInfo)this.tableModel.getValueAt(n, n2);
            Shell shell = MainShell.getInstance();
            shell.launchHelp(exceptionInfo.getHelpSetName(), exceptionInfo.getHelpID(), (Window)this);
        }
    }

    private class ExceptionInfo {
        public final Exception exception;

        public ExceptionInfo(Exception exception) {
            this.exception = exception;
        }

        public boolean supportsHelp() {
            String string = this.getHelpID();
            return string != null && string.length() > 0;
        }

        public String getHelpSetName() {
            if (this.exception instanceof SnapinException) {
                return ((SnapinException)this.exception).getHelpSetName();
            }
            return null;
        }

        public String getHelpID() {
            if (this.exception instanceof SnapinException) {
                return ((SnapinException)this.exception).getHelpID();
            }
            return null;
        }

        public String toString() {
            return this.exception.getLocalizedMessage();
        }
    }
}

