/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.widgets.DefaultMobilityStrategy;
import com.novell.gw.admin.widgets.GwList;
import com.novell.gw.admin.widgets.MobilityStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OrderedDualList
extends JPanel
implements ActionListener,
ListDataListener,
ListSelectionListener {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private boolean isDataMovingHoriz = false;
    private Vector[][] freezes = new Vector[2][2];
    private JList[] lists = new JList[2];
    private JScrollPane[] scrollPanes = new JScrollPane[2];
    private DefaultListModel[] listModels = new DefaultListModel[2];
    private JButton[] horizButton = new JButton[2];
    private JButton[][] vertButton = new JButton[2][2];
    private MobilityStrategy strategy = new DefaultMobilityStrategy();
    private boolean preJava14 = false;

    public OrderedDualList() {
        this("", "");
    }

    public OrderedDualList(String string, String string2) {
        this.initComponents(string, string2);
        this.addListeners();
    }

    private void initComponents(String string, String string2) {
        String string3 = System.getProperty("java.version");
        if (string3.startsWith("1.1") || string3.startsWith("1.2") || string3.startsWith("1.3")) {
            this.preJava14 = true;
        }
        this.setLayout(new GridBagLayout());
        JLabel jLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string), (String)string, (String)"");
        int n = jLabel.getPreferredSize().height;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.lists[0] = new GwList();
        this.lists[0].getAccessibleContext().setAccessibleName(jLabel.getText());
        this.listModels[0] = new DefaultListModel();
        this.lists[0].setModel(this.listModels[0]);
        if (!this.preJava14) {
            this.lists[0].setSelectionModel(new DualListSelectionModel());
        }
        this.scrollPanes[0] = new JScrollPane(this.lists[0]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollPanes[0], gridBagConstraints);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        Dimension dimension = new Dimension(30, 30);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/com/novell/gw/admin/widgets/images/prev24.gif"));
        this.horizButton[0] = NConeFactory.novellJButton((JButton)new JButton(imageIcon), (String)"Previous", (String)"");
        this.horizButton[0].setMinimumSize(dimension);
        this.horizButton[0].setPreferredSize(dimension);
        this.horizButton[0].setEnabled(false);
        this.horizButton[0].addActionListener(this);
        box.add(this.horizButton[0]);
        box.add(Box.createVerticalStrut(5));
        ImageIcon imageIcon2 = new ImageIcon(this.getClass().getResource("/com/novell/gw/admin/widgets/images/next24.gif"));
        this.horizButton[1] = NConeFactory.novellJButton((JButton)new JButton(imageIcon2), (String)"next", (String)"");
        this.horizButton[1].setMinimumSize(dimension);
        this.horizButton[1].setPreferredSize(dimension);
        this.horizButton[1].setEnabled(false);
        this.horizButton[1].addActionListener(this);
        box.add(this.horizButton[1]);
        box.add(Box.createVerticalGlue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)box, gridBagConstraints);
        jLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string2), (String)string2, (String)"");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        this.add((Component)jLabel, gridBagConstraints);
        this.lists[1] = new GwList();
        this.lists[1].getAccessibleContext().setAccessibleName(jLabel.getText());
        this.listModels[1] = new DefaultListModel();
        this.lists[1].setModel(this.listModels[1]);
        if (!this.preJava14) {
            this.lists[1].setSelectionModel(new DualListSelectionModel());
        }
        this.scrollPanes[1] = new JScrollPane(this.lists[1]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.scrollPanes[1], gridBagConstraints);
        ImageIcon imageIcon3 = new ImageIcon(this.getClass().getResource("/com/novell/gw/admin/widgets/images/up24.gif"));
        ImageIcon imageIcon4 = new ImageIcon(this.getClass().getResource("/com/novell/gw/admin/widgets/images/down24.gif"));
        JPanel jPanel = NConeFactory.novellJPanel((JPanel)new JPanel(), (String)"", (String)"");
        this.vertButton[0][0] = NConeFactory.novellJButton((JButton)new JButton(imageIcon3), (String)"up", (String)"");
        this.vertButton[0][0].setMinimumSize(dimension);
        this.vertButton[0][0].setPreferredSize(dimension);
        this.vertButton[0][0].setVisible(false);
        this.vertButton[0][0].setEnabled(false);
        this.vertButton[0][0].addActionListener(this);
        jPanel.add(this.vertButton[0][0]);
        this.vertButton[0][1] = NConeFactory.novellJButton((JButton)new JButton(imageIcon4), (String)"down", (String)"");
        this.vertButton[0][1].setMinimumSize(dimension);
        this.vertButton[0][1].setPreferredSize(dimension);
        this.vertButton[0][1].setVisible(false);
        this.vertButton[0][1].setEnabled(false);
        this.vertButton[0][1].addActionListener(this);
        jPanel.add(this.vertButton[0][1]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = new JPanel();
        this.vertButton[1][0] = NConeFactory.novellJButton((JButton)new JButton(imageIcon3), (String)"up", (String)"");
        this.vertButton[1][0].setMinimumSize(dimension);
        this.vertButton[1][0].setPreferredSize(dimension);
        this.vertButton[1][0].setVisible(false);
        this.vertButton[1][0].setEnabled(false);
        this.vertButton[1][0].addActionListener(this);
        jPanel.add(this.vertButton[1][0]);
        this.vertButton[1][1] = NConeFactory.novellJButton((JButton)new JButton(imageIcon4), (String)"down", (String)"");
        this.vertButton[1][1].setMinimumSize(dimension);
        this.vertButton[1][1].setPreferredSize(dimension);
        this.vertButton[1][1].setVisible(false);
        this.vertButton[1][1].setEnabled(false);
        this.vertButton[1][1].addActionListener(this);
        jPanel.add(this.vertButton[1][1]);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void addListeners() {
        this.lists[0].addListSelectionListener(this);
        this.lists[1].addListSelectionListener(this);
        if (this.preJava14) {
            this.listModels[0].addListDataListener(this);
            this.listModels[1].addListDataListener(this);
        }
    }

    public void setEnabled(boolean bl) {
        for (int i = 0; i < 2; ++i) {
            JList jList = this.lists[i];
            if (jList != null) {
                jList.setEnabled(bl);
            }
            if (bl) continue;
            JButton jButton = this.horizButton[i];
            if (jButton != null) {
                jButton.setEnabled(false);
            }
            for (int j = 0; j < 2; ++j) {
                jButton = this.vertButton[i][j];
                if (jButton == null) continue;
                jButton.setEnabled(false);
            }
        }
    }

    public void setListPrefSize(Dimension dimension, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        this.scrollPanes[n].setPreferredSize(dimension);
    }

    public void setMobilityStrategy(MobilityStrategy mobilityStrategy) {
        this.strategy = mobilityStrategy;
    }

    public void setModel(DefaultListModel defaultListModel, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        this.lists[n].setModel(defaultListModel);
        if (this.preJava14) {
            this.listModels[n].removeListDataListener(this);
        }
        this.listModels[n] = defaultListModel;
        if (this.preJava14) {
            this.listModels[n].addListDataListener(this);
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        this.lists[n].addListSelectionListener(listSelectionListener);
    }

    public void setVerticalArrowsVisible(boolean bl, int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        this.vertButton[n][0].setVisible(bl);
        this.vertButton[n][1].setVisible(bl);
    }

    public JList getList(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException();
        }
        return this.lists[n];
    }

    private void moveSelectedUp(int n) {
        this.moveSelectedVert(n, -1);
    }

    private void moveSelectedDown(int n) {
        this.moveSelectedVert(n, 1);
    }

    private void moveSelectedVert(int n, int n2) {
        int n3 = this.lists[n].getSelectedIndex();
        Object e = this.listModels[n].elementAt(n3);
        this.listModels[n].removeElementAt(n3);
        this.listModels[n].insertElementAt(e, n3 += n2);
        this.lists[n].addSelectionInterval(n3, n3);
        this.updateEnabling(n);
    }

    private void updateEnabling(int n) {
        int[] nArray = this.lists[n].getSelectedIndices();
        boolean bl = nArray.length > 0;
        boolean bl2 = nArray.length == 1;
        boolean bl3 = bl;
        if (bl) {
            bl3 &= this.strategy.canMoveToOtherList(nArray, n, this);
        }
        this.horizButton[this.otherSide(n)].setEnabled(bl3);
        boolean bl4 = bl2;
        if (bl2) {
            bl4 &= nArray[0] != 0 && this.strategy.canMoveUp(nArray[0], n, this);
        }
        this.vertButton[n][0].setEnabled(bl4);
        boolean bl5 = bl2;
        if (bl2) {
            int n2 = this.listModels[n].getSize();
            bl5 &= nArray[0] < n2 - 1 && this.strategy.canMoveDown(nArray[0], n, this);
        }
        this.vertButton[n][1].setEnabled(bl5);
    }

    public int otherSide(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    private void moveSelectedHoriz(int n) {
        int n2 = this.otherSide(n);
        int n3 = this.lists[n2].getMinSelectionIndex();
        int n4 = this.lists[n2].getMaxSelectionIndex();
        int n5 = this.listModels[n].size();
        for (int i = n4; i >= n3; --i) {
            if (!this.lists[n2].isSelectedIndex(i)) continue;
            this.isDataMovingHoriz = true;
            Object e = this.listModels[n2].elementAt(i);
            this.listModels[n2].removeElementAt(i);
            this.listModels[n].insertElementAt(e, n5);
            this.isDataMovingHoriz = false;
        }
        this.lists[n].requestFocus();
        this.updateEnabling(0);
        this.updateEnabling(1);
    }

    public void addElement(Object object, int n) {
        this.listModels[n].addElement(object);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.isDataMovingHoriz) {
            JList jList;
            Object object = listDataEvent.getSource();
            if (object == this.listModels[0]) {
                jList = this.lists[0];
            } else if (object == this.listModels[1]) {
                jList = this.lists[1];
            } else {
                return;
            }
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            ListSelectionModel listSelectionModel = jList.getSelectionModel();
            listSelectionModel.insertIndexInterval(n, n2 - n + 1, true);
            listSelectionModel.addSelectionInterval(n, n2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.horizButton[0]) {
            this.moveSelectedHoriz(0);
        } else if (object == this.horizButton[1]) {
            this.moveSelectedHoriz(1);
        } else if (object == this.vertButton[0][0]) {
            this.moveSelectedUp(0);
        } else if (object == this.vertButton[0][1]) {
            this.moveSelectedDown(0);
        } else if (object == this.vertButton[1][0]) {
            this.moveSelectedUp(1);
        } else if (object == this.vertButton[1][1]) {
            this.moveSelectedDown(1);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.lists[0]) {
            this.updateEnabling(0);
        } else if (object == this.lists[1]) {
            this.updateEnabling(1);
        }
    }

    private class DualListSelectionModel
    extends DefaultListSelectionModel {
        private DualListSelectionModel() {
        }

        public void insertIndexInterval(int n, int n2, boolean bl) {
            super.insertIndexInterval(n, n2, bl);
            if (OrderedDualList.this.isDataMovingHoriz) {
                int n3 = bl ? n : n + 1;
                int n4 = n3 + n2 - 1;
                this.addSelectionInterval(n3, n4);
            }
        }
    }
}

