/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.RB;
import com.novell.gw.admin.widgets.SchedGridEvent;
import com.novell.gw.admin.widgets.SchedGridListener;
import com.novell.gw.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SchedGrid
extends JPanel
implements ActionListener,
MouseListener {
    public static final Color DEFAULT_CELL_COLOR = Color.white;
    public static final Color CURRENT_CELL_COLOR = new Color(60, 150, 60);
    public static final Color OTHER_CELL_COLOR = Color.lightGray;
    public static final int DEFAULT_INDEX = -1;
    private int currentIndex = -1;
    public static final int INVALID_INDEX = -2;
    public static final int ROWS = 7;
    public static final int COLS = 48;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int HOURS_PER_WEEK = 168;
    private GridSelector grid = new GridSelector();
    private JLabel curPointLabel = new JLabel(" ", 0);
    private JButton resetButton = null;
    private Vector listeners;

    public SchedGrid() {
        this.setLayout(new BorderLayout(6, 6));
        this.resetButton = RB.getButton("UndoKey");
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.curPointLabel, "Center");
        jPanel.add((Component)this.resetButton, "West");
        this.resetButton.setEnabled(false);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1), true);
        jPanel2.setPreferredSize(new Dimension(480, 145));
        jPanel2.add(this.grid);
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "South");
        this.listeners = new Vector();
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                SchedGrid.this.curPointLabel.setText(SchedGrid.this.grid.getTimeStringFromDP(mouseEvent.getPoint()));
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                SchedGrid.this.curPointLabel.setText(SchedGrid.this.grid.getTimeStringFromDP(mouseEvent.getPoint()));
            }
        };
        this.grid.addMouseMotionListener(mouseMotionAdapter);
        this.grid.addMouseListener(this);
        this.resetButton.addActionListener(this);
    }

    public JButton getResetButton() {
        return this.resetButton;
    }

    public void setCurrentIndex(int n) {
        this.currentIndex = n;
        this.grid.repaint();
    }

    public int[][] getSelection() {
        return this.grid.getSelection();
    }

    public void setSelection(int[][] nArray) {
        this.grid.setSelection(nArray);
    }

    public int removeIndex(int n) {
        if (n == -1) {
            return 1;
        }
        int[][] nArray = this.getSelection();
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 48; ++j) {
                if (nArray[i][j] != n) continue;
                nArray[i][j] = -1;
            }
        }
        this.setSelection(nArray);
        return 0;
    }

    public void setEnabled(boolean bl) {
        this.grid.setEnabled(bl);
        if (!bl) {
            this.resetButton.setEnabled(false);
        }
    }

    public boolean isModified() {
        return this.grid.isModified();
    }

    public void setModified(boolean bl) {
        this.grid.setModified(bl);
    }

    public void addSchedGridListener(SchedGridListener schedGridListener) {
        if (!this.listeners.contains(schedGridListener)) {
            this.listeners.addElement(schedGridListener);
        }
    }

    public void removeSchedGridListener(SchedGridListener schedGridListener) {
        if (this.listeners.contains(schedGridListener)) {
            this.listeners.removeElement(schedGridListener);
        }
    }

    private void dispatch(int n) {
        SchedGridEvent schedGridEvent = new SchedGridEvent(this, n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SchedGridListener)this.listeners.elementAt(i)).schedGridChanged(schedGridEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.resetButton.setEnabled(false);
        this.dispatch(2);
        this.grid.reset(true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.grid.isEnabled()) {
            this.dispatch(1);
            this.resetButton.setEnabled(true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class GridSelector
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private int width;
        private int height;
        private int columnWidth;
        private int rowHeight;
        private int[][] currentSel;
        private int[][] origSel;
        private Point startPoint;
        private Point lastCurPoint;
        private Graphics g;
        private final Color gridLinesColor = Color.black;
        private int xoffset;
        private int yoffset;
        private int tickHeight = 4;
        private final String[] rowHeaders = RB.getStringArray("weekdaysCDL");
        private final String[] times = RB.getStringArray("timesCDL");
        private final String[] columnHeaders = RB.getStringArray("hoursCDL");
        private boolean enab = true;
        private boolean isModified = false;

        public GridSelector() {
            Debug.assrt((this.rowHeaders.length == 7 ? 1 : 0) != 0, (String)"GridSelector: Invalid weekdaysCDL");
            Debug.assrt((this.times.length * 2 == 48 ? 1 : 0) != 0, (String)"GridSelector: Invalid timesCDL");
            this.currentSel = new int[7][48];
            this.origSel = new int[7][48];
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            ComponentAdapter componentAdapter = new ComponentAdapter(this){
                private final /* synthetic */ GridSelector this$1;
                {
                    this.this$1 = gridSelector;
                }

                public void componentResized(ComponentEvent componentEvent) {
                    Dimension dimension = componentEvent.getComponent().getSize();
                    GridSelector.access$202(this.this$1, (dimension.width - GridSelector.access$300(this.this$1)) / 48);
                    GridSelector.access$402(this.this$1, (dimension.height - GridSelector.access$500(this.this$1)) / 7);
                    GridSelector.access$602(this.this$1, 48 * GridSelector.access$200(this.this$1));
                    GridSelector.access$702(this.this$1, 7 * GridSelector.access$400(this.this$1));
                }
            };
            this.addComponentListener(componentAdapter);
        }

        public Dimension getPreferredSize() {
            int n = 20;
            int n2 = 10;
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                graphics.setFont(this.getFont());
                FontMetrics fontMetrics = graphics.getFontMetrics();
                n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
                n2 = fontMetrics.stringWidth(this.columnHeaders[0]) / this.columnHeaders[0].length();
            }
            return new Dimension(this.xoffset + 48 * n2, this.yoffset + 7 * n);
        }

        public void addNotify() {
            super.addNotify();
            Graphics graphics = this.getGraphics();
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            this.tickHeight = n / 4;
            int n2 = this.rowHeaders.length;
            while (n2-- > 0) {
                this.xoffset = Math.max(this.xoffset, fontMetrics.stringWidth(this.rowHeaders[n2]));
            }
            this.xoffset += 5;
            this.yoffset = this.tickHeight + (n + 1) * 2;
            Dimension dimension = this.getParent().getSize();
            this.columnWidth = -1;
            this.rowHeight = (dimension.height - this.yoffset) / 7;
            this.width = 48 * this.columnWidth;
            this.height = 7 * this.rowHeight;
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4 = this.xoffset;
            int n5 = this.yoffset;
            int n6 = 0;
            while (n6 < 7) {
                n4 = this.xoffset;
                n3 = 0;
                while (n3 < 48) {
                    if (this.currentSel[n6][n3] == -1) {
                        graphics.setColor(DEFAULT_CELL_COLOR);
                    } else if (this.currentSel[n6][n3] == SchedGrid.this.currentIndex) {
                        graphics.setColor(CURRENT_CELL_COLOR);
                    } else {
                        graphics.setColor(OTHER_CELL_COLOR);
                    }
                    graphics.fillRect(n4, n5, this.columnWidth, this.rowHeight);
                    ++n3;
                    n4 += this.columnWidth;
                }
                ++n6;
                n5 += this.rowHeight;
            }
            graphics.setColor(this.gridLinesColor);
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n7 = this.xoffset + this.columnWidth * 48;
            int n8 = 0;
            int n9 = 0;
            for (n4 = this.xoffset; n4 <= n7; n4 += this.columnWidth) {
                n2 = this.yoffset;
                if (n9++ % 4 == 0) {
                    n = n8 % this.columnHeaders.length;
                    String string = this.columnHeaders[n];
                    int n10 = fontMetrics.stringWidth(string);
                    graphics.drawString(string, n4 - n10 / 2, (n2 -= this.tickHeight) - 1);
                    if (n == 0) {
                        if (n8 == this.columnHeaders.length) {
                            graphics.drawString(RB.getString("lsPM"), n4 - n10 / 2, n3 + 1);
                        } else {
                            graphics.drawString(RB.getString("lsAM"), n4 - n10 / 2, n3 + 1);
                        }
                    }
                    ++n8;
                }
                graphics.drawLine(n4, n2, n4, this.yoffset + this.height);
            }
            n2 = this.yoffset + this.rowHeight * 7;
            n = 0;
            for (n5 = this.yoffset; n5 <= n2; n5 += this.rowHeight) {
                graphics.drawLine(this.xoffset, n5, this.xoffset + this.width, n5);
                if (n5 >= n2) continue;
                graphics.drawString(this.rowHeaders[n++], 0, n5 + (this.rowHeight + fontMetrics.getAscent() - 1) / 2);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.enab) {
                return;
            }
            if (this.startPoint == null) {
                return;
            }
            this.isModified = true;
            Point point = this.sizeToBounds(mouseEvent.getPoint());
            Point point2 = this.DPtoLP(point);
            this.g.setColor(this.gridLinesColor);
            if (this.lastCurPoint != null) {
                this.g.setXORMode(Color.white);
                this.g.drawRect(Math.min(this.startPoint.x, this.lastCurPoint.x), Math.min(this.startPoint.y, this.lastCurPoint.y), Math.abs(this.lastCurPoint.x - this.startPoint.x), Math.abs(this.lastCurPoint.y - this.startPoint.y));
            }
            this.g.drawRect(Math.min(this.startPoint.x, point.x), Math.min(this.startPoint.y, point.y), Math.abs(point.x - this.startPoint.x), Math.abs(point.y - this.startPoint.y));
            this.lastCurPoint = point;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.enab) {
                return;
            }
            this.isModified = true;
            this.lastCurPoint = this.startPoint = this.sizeToBounds(mouseEvent.getPoint());
            this.g = this.getGraphics();
            this.g.setFont(this.getFont());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.enab) {
                return;
            }
            if (this.startPoint == null) {
                return;
            }
            if (this.lastCurPoint != null) {
                this.isModified = true;
                this.g.setColor(this.gridLinesColor);
                this.g.setXORMode(Color.white);
                this.g.drawRect(Math.min(this.startPoint.x, this.lastCurPoint.x), Math.min(this.startPoint.y, this.lastCurPoint.y), Math.abs(this.lastCurPoint.x - this.startPoint.x), Math.abs(this.lastCurPoint.y - this.startPoint.y));
                Point point = this.DPtoLP(this.startPoint);
                Point point2 = this.DPtoLP(this.lastCurPoint);
                int n = Math.min(point.x, point2.x);
                int n2 = Math.min(point.y, point2.y);
                int n3 = Math.max(point.x, point2.x);
                int n4 = Math.max(point.y, point2.y);
                int n5 = SchedGrid.this.currentIndex;
                if (n5 != -1 && n5 == this.currentSel[point2.y][point2.x]) {
                    n5 = -1;
                }
                for (int i = n2; i <= n4; ++i) {
                    for (int j = n; j <= n3; ++j) {
                        this.currentSel[i][j] = n5;
                    }
                }
                this.repaint(this.xoffset + n * this.columnWidth, this.yoffset + n2 * this.rowHeight, (n3 - n + 1) * this.columnWidth, (n4 - n2 + 1) * this.rowHeight);
                this.lastCurPoint = null;
            }
            this.startPoint = null;
            this.g.dispose();
            this.g = null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        private Point DPtoLP(Point point) {
            Point point2 = new Point();
            point2.x = (point.x - this.xoffset) / this.columnWidth;
            point2.y = (point.y - this.yoffset) / this.rowHeight;
            return point2;
        }

        public String toString() {
            String string = new String();
            string = string + "\nwidth = " + this.width;
            string = string + "\nheight = " + this.height;
            string = string + "\ncolumnWidth = " + this.columnWidth;
            string = string + "\nrowHeight = " + this.rowHeight;
            return string;
        }

        private Point sizeToBounds(Point point) {
            point.x = Math.min(this.xoffset + this.width - 1, Math.max(this.xoffset, point.x));
            point.y = Math.min(this.yoffset + this.height - 1, Math.max(this.yoffset, point.y));
            return point;
        }

        public void reset(boolean bl) {
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 48; ++j) {
                    this.currentSel[i][j] = this.origSel[i][j];
                }
            }
            if (bl) {
                this.repaint();
            }
            this.isModified = false;
        }

        public int[][] getSelection() {
            return this.currentSel;
        }

        public void setSelection(int[][] nArray) {
            if (nArray.length != 7) {
                Debug.trace((String)("setSelection: illegal row count: " + nArray.length + " (must be " + 7 + ")"));
                throw new IllegalArgumentException();
            }
            if (nArray[0].length != 48) {
                Debug.trace((String)("setSelection: illegal column count: " + nArray[0].length + " (must be " + 48 + ")"));
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 48; ++j) {
                    this.currentSel[i][j] = nArray[i][j];
                    this.origSel[i][j] = nArray[i][j];
                }
            }
            SchedGrid.this.grid.repaint();
        }

        public String getTimeStringFromDP(Point point) {
            point = this.DPtoLP(point);
            String string = " ";
            if (point.x >= 0 && point.x < this.times.length * 2 && point.y >= 0 && point.y < this.rowHeaders.length) {
                string = this.rowHeaders[point.y];
                string = string + " ";
                string = string + this.times[point.x % this.times.length];
                string = string + (point.x > this.times.length ? " pm" : " am");
            }
            return string;
        }

        public void setEnabled(boolean bl) {
            this.enab = bl;
        }

        public boolean isEnabled() {
            return this.enab;
        }

        public boolean isModified() {
            return this.isModified;
        }

        public void setModified(boolean bl) {
            this.isModified = bl;
        }

        static /* synthetic */ int access$202(GridSelector gridSelector, int n) {
            gridSelector.columnWidth = n;
            return gridSelector.columnWidth;
        }

        static /* synthetic */ int access$300(GridSelector gridSelector) {
            return gridSelector.xoffset;
        }

        static /* synthetic */ int access$402(GridSelector gridSelector, int n) {
            gridSelector.rowHeight = n;
            return gridSelector.rowHeight;
        }

        static /* synthetic */ int access$500(GridSelector gridSelector) {
            return gridSelector.yoffset;
        }

        static /* synthetic */ int access$602(GridSelector gridSelector, int n) {
            gridSelector.width = n;
            return gridSelector.width;
        }

        static /* synthetic */ int access$200(GridSelector gridSelector) {
            return gridSelector.columnWidth;
        }

        static /* synthetic */ int access$702(GridSelector gridSelector, int n) {
            gridSelector.height = n;
            return gridSelector.height;
        }

        static /* synthetic */ int access$400(GridSelector gridSelector) {
            return gridSelector.rowHeight;
        }
    }
}

