/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.admin.common.StringFormat;
import com.novell.gw.admin.widgets.EditField;
import com.novell.gw.admin.widgets.IPEditor;
import com.novell.gw.admin.widgets.RB;
import com.novell.utility.localization.Loc;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TCPAddressEditor
extends JPanel
implements SwingConstants,
ItemListener,
ChangeListener {
    private JRadioButton ipButton = new JRadioButton(StringFormat.formatLabel(RB.getString("IPAddress")));
    private JRadioButton dnsButton;
    private EditField hostField;
    private IPEditor ipEditor;
    private ButtonGroup buttonGroup;
    private ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public TCPAddressEditor() {
        this((String)null);
    }

    public TCPAddressEditor(String string) {
        super(new GridBagLayout(), true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.ipButton, gridBagConstraints);
        this.add(this.ipButton);
        this.ipEditor = new IPEditor();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.ipEditor, gridBagConstraints);
        this.add(this.ipEditor);
        this.dnsButton = new JRadioButton(StringFormat.formatLabel(RB.getString("DNSHostName")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.dnsButton, gridBagConstraints);
        this.add(this.dnsButton);
        this.hostField = new EditField();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 1, 0, 0);
        NConeFactory.novellJTextField((JTextField)this.hostField, (String)RB.getString("DNSHostName"), (String)"This is a textfield");
        ((GridBagLayout)this.getLayout()).setConstraints(this.hostField, gridBagConstraints);
        this.add(this.hostField);
        this.hostField.addChangeListener(this);
        this.ipEditor.addChangeListener(this);
        this.ipButton.addItemListener(this);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.ipButton);
        this.buttonGroup.add(this.dnsButton);
        this.ipButton.setSelected(true);
        this.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(0, 2, 2, 2)));
        this.enableEvents(4L);
        if (string == null) {
            string = RB.getString("TCP_IP_Address");
        }
        NConeFactory.novellJRadioButton((JRadioButton)this.ipButton, (String)(string + "             " + Loc.removeHotChar((String)StringFormat.formatLabel(RB.getString("IPAddress")))), (String)"");
        NConeFactory.novellJRadioButton((JRadioButton)this.dnsButton, (String)(string + "            " + Loc.removeHotChar((String)StringFormat.formatLabel(RB.getString("DNSHostName")))), (String)"");
        this.setBorder(new TitledBorder(this.getBorder(), string));
    }

    public void print() {
        this.ipEditor.print();
    }

    public void setEnabled(boolean bl) {
        this.ipButton.setEnabled(bl);
        this.dnsButton.setEnabled(bl);
        if (this.ipButton.isSelected()) {
            this.ipEditor.setEnabled(bl);
        } else {
            this.hostField.setEnabled(bl);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TCPAddressEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = TCPAddressEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? TCPAddressEditor.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004) {
            if (this.ipButton.isSelected()) {
                this.ipEditor.requestFocus();
            } else {
                this.hostField.requestFocus();
            }
        }
    }

    private boolean isIPAddress(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || string.charAt(i) == '.') continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setValue(String string) {
        if (this.isIPAddress(string)) {
            this.ipEditor.setValue(string);
            this.ipButton.setSelected(true);
        } else {
            this.hostField.setText(string);
            this.dnsButton.setSelected(true);
        }
    }

    public String getValue() {
        return new String(this.ipButton.isSelected() ? this.ipEditor.getValue() : this.hostField.getText());
    }

    public boolean isAddressValid() {
        boolean bl = false;
        bl = this.ipButton.isSelected() ? this.ipEditor.isValueValid() : this.hostField.getDocument().getLength() > 0;
        return bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.ipButton.isSelected()) {
            this.ipEditor.setEnabled(true);
            this.hostField.setEnabled(false);
        } else {
            this.ipEditor.setEnabled(false);
            this.hostField.setEnabled(true);
        }
        this.fireStateChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

