/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ThreeStateCheckBox
extends JPanel
implements ItemListener,
ItemSelectable {
    public static final int DESELECTED = 0;
    public static final int SELECTED = 1;
    public static final int SEMI_SELECTED = 2;
    private DisabledCheckBox cb;
    private JLabel label;
    private boolean enabled;
    private int selectionState;
    private ItemListener itemListener;

    public ThreeStateCheckBox() {
        this.initComponents();
        this.addListeners();
        this.selectionState = 0;
        this.enabled = true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.cb = new DisabledCheckBox();
        this.cb.addItemListener(this);
        this.add((Component)this.cb, "West");
        this.label = new TestLabel();
        this.add((Component)this.label, "Center");
    }

    private void addListeners() {
        this.enableEvents(16L);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.selectionState == 1) {
            return new Object[]{this.label.getText()};
        }
        return null;
    }

    public JCheckBox getCheckBox() {
        return this.cb;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.label.setEnabled(bl);
        if (this.selectionState != 2) {
            this.cb.setEnabled(bl);
        }
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setText(String string) {
        this.label.setText(string);
        this.label = NConeFactory.novellJLabel((JLabel)this.label, (String)string, (String)"");
    }

    public boolean isDeselected() {
        return this.selectionState == 0;
    }

    public boolean isSelected() {
        return this.selectionState == 1;
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.setSelectionState(1);
        } else {
            this.setSelectionState(0);
        }
    }

    public boolean isSemiSelected() {
        return this.selectionState == 2;
    }

    public void setSemiSelected() {
        this.setSelectionState(2);
    }

    public int getSelectionState() {
        return this.selectionState;
    }

    public void setSelectionState(int n) {
        if (n != 0 && n != 2 && n != 1) {
            return;
        }
        this.selectionState = n;
        if (this.selectionState == 0) {
            this.cb.setSelected(false);
        } else {
            this.cb.setSelected(true);
        }
        if (this.selectionState == 2) {
            this.cb.setEnabled(false);
        } else {
            this.cb.setEnabled(this.enabled);
        }
    }

    public void doClick() {
        if (this.selectionState == 1) {
            this.setSelectionState(0);
        } else {
            this.setSelectionState(1);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            ItemEvent itemEvent2 = new ItemEvent(this, itemEvent.getID(), itemEvent.getItem(), itemEvent.getStateChange());
            this.itemListener.itemStateChanged(itemEvent2);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return;
        }
        int n = mouseEvent.getID();
        if (n == 501 || n == 502) {
            Serializable serializable;
            Point point = mouseEvent.getPoint();
            Object object = mouseEvent.getSource();
            if (object == this.label) {
                serializable = this.label.getLocation();
                point.x += serializable.x;
                point.y += serializable.y;
            }
            serializable = new MouseEvent(this, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            if (n == 501) {
                this.mousePressed((MouseEvent)serializable);
            } else if (n == 502) {
                this.mouseReleased((MouseEvent)serializable);
            }
        }
    }

    private void mousePressed(MouseEvent mouseEvent) {
    }

    private void mouseReleased(MouseEvent mouseEvent) {
        if (this.contains(mouseEvent.getPoint())) {
            this.doClick();
        }
    }

    private class TestLabel
    extends JLabel {
        TestLabel() {
            this.enableEvents(16L);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            ThreeStateCheckBox.this.processMouseEvent(mouseEvent);
        }
    }

    private class DisabledCheckBox
    extends JCheckBox {
        DisabledCheckBox() {
            this.enableEvents(16L);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            ThreeStateCheckBox.this.processMouseEvent(mouseEvent);
        }
    }
}

