/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.GWBorder;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolBarToggleButton
extends JToggleButton {
    private Insets insets = new Insets(5, 5, 5, 5);

    public ToolBarToggleButton(ImageIcon imageIcon) {
        this.setModel(new ToolBarToggleButtonModel());
        this.setIcon(imageIcon);
        this.init();
    }

    public ToolBarToggleButton(Action action) {
        this.setModel(new ToolBarToggleButtonModel());
        this.setAction(action);
        this.init();
    }

    public ButtonGroup getGroup() {
        return ((ToolBarToggleButtonModel)this.getModel()).getGroup();
    }

    protected void init() {
        this.setFocusable(false);
        this.addMouseListener(new ButtonMouseAdapter());
        this.addChangeListener(new ButtonChangeListener());
        this.setBorder(GWBorder.NO_BORDER);
        this.setMargin(this.insets);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setMargin(Insets insets) {
        super.setMargin(insets);
        this.insets = insets;
    }

    class ToolBarToggleButtonModel
    extends JToggleButton.ToggleButtonModel {
        ToolBarToggleButtonModel() {
        }

        public boolean isSelected() {
            if (this.getGroup() != null) {
                return this.getGroup().isSelected(this);
            }
            return (this.stateMask & 2) != 0;
        }

        public void setSelected(boolean bl) {
            ButtonGroup buttonGroup = this.getGroup();
            if (buttonGroup != null) {
                buttonGroup.setSelected(this, bl);
                bl = buttonGroup.isSelected(this);
            } else if (this.isSelected() == bl) {
                return;
            }
            this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }
    }

    class ButtonChangeListener
    implements ChangeListener {
        ButtonChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (ToolBarToggleButton.this.isSelected()) {
                ToolBarToggleButton.this.setBorder(GWBorder.LOWERED_BORDER);
            } else {
                ToolBarToggleButton.this.setBorder(GWBorder.NO_BORDER);
            }
        }
    }

    class ButtonMouseAdapter
    extends MouseAdapter {
        ButtonMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton.this.setBorder(GWBorder.RAISED_BORDER);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton.this.setBorder(GWBorder.NO_BORDER);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                    return;
                }
                ToolBarToggleButton.this.setBorder(GWBorder.LOWERED_BORDER);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!ToolBarToggleButton.this.isEnabled() || ToolBarToggleButton.this.isSelected()) {
                return;
            }
            ToolBarToggleButton toolBarToggleButton = ToolBarToggleButton.this;
            boolean bl = false;
            if (0 <= mouseEvent.getX() && mouseEvent.getX() < toolBarToggleButton.getSize().width && 0 <= mouseEvent.getY() && mouseEvent.getY() < toolBarToggleButton.getSize().height) {
                toolBarToggleButton.setBorder(GWBorder.RAISED_BORDER);
            } else {
                toolBarToggleButton.setBorder(GWBorder.NO_BORDER);
            }
        }
    }
}

