/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.gw.admin.widgets.GWTextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.text.Document;

public class ValidatingTextField
extends GWTextField {
    private int maxLength = 0;
    public static final String GW_NAME_INVALID_CHARS = ".,:{}()\"*@";
    private Hashtable invalidCharHash;

    public static ValidatingTextField createNamingField() {
        ValidatingTextField validatingTextField = new ValidatingTextField();
        validatingTextField.setInvalidChars(GW_NAME_INVALID_CHARS);
        return validatingTextField;
    }

    public ValidatingTextField() {
        this.init();
    }

    public ValidatingTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    public ValidatingTextField(int n) {
        super(n);
        this.init();
    }

    public ValidatingTextField(String string) {
        super(string);
        this.init();
    }

    public ValidatingTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    private void init() {
        this.enableEvents(8L);
    }

    public void setInvalidChars(String string) {
        this.setInvalidChars(string.toCharArray());
    }

    public void setInvalidChars(char[] cArray) {
        int n = cArray.length;
        int n2 = n * 4 / 3;
        this.invalidCharHash = new Hashtable(n2);
        for (int i = 0; i < n; ++i) {
            Character c = new Character(cArray[i]);
            this.invalidCharHash.put(c, c);
        }
    }

    public void setMaxLength(int n) {
        this.maxLength = n;
    }

    private boolean isValidChar(char c) {
        boolean bl = true;
        if (this.invalidCharHash != null) {
            Character c2 = new Character(c);
            bl = !this.invalidCharHash.containsKey(c2);
        }
        return bl;
    }

    private boolean isValidString(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (this.isValidChar(cArray[i])) continue;
            return false;
        }
        return true;
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                boolean bl = this.isValidString(string);
                if (!bl) {
                    this.getToolkit().beep();
                    return;
                }
                this.replaceSelection(string);
            }
            catch (Exception exception) {
                this.getToolkit().beep();
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = true;
        if (this.isEditable() && this.isEnabled() && keyEvent.getID() == 400) {
            char c = keyEvent.getKeyChar();
            if (!this.isValidChar(c)) {
                this.getToolkit().beep();
                bl = false;
            } else if (this.maxLength != 0 && this.getText().length() >= this.maxLength) {
                this.getToolkit().beep();
                bl = false;
            }
        }
        if (bl) {
            super.processKeyEvent(keyEvent);
        }
    }
}

