/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.admin.widgets;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.util.Debug;
import com.novell.utility.localization.Loc;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class WrapButton
extends JComponent
implements MouseListener {
    private static final Font DEFAULT_LABEL_FONT = new JLabel().getFont();
    AbstractButton button;
    WrapButtonLabel wrapLabel;
    boolean clicked = false;
    boolean overObj = false;

    public WrapButton(String string, AbstractButton abstractButton) {
        if (abstractButton instanceof JCheckBox) {
            NConeFactory.novellJCheckBox((JCheckBox)((JCheckBox)abstractButton), (String)Loc.removeHotChar((String)string), (String)"");
        } else if (abstractButton instanceof JRadioButton) {
            NConeFactory.novellJRadioButton((JRadioButton)((JRadioButton)abstractButton), (String)Loc.removeHotChar((String)string), (String)"");
        } else if (abstractButton instanceof JButton) {
            NConeFactory.novellJButton((JButton)((JButton)abstractButton), (String)Loc.removeHotChar((String)string), (String)"");
        } else {
            Debug.trace((String)("WrapButton:  Add NConeFactory stuff for this button: " + abstractButton));
        }
        abstractButton.setMargin(new Insets(0, 2, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.button = abstractButton;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(abstractButton, gridBagConstraints);
        this.add(abstractButton);
        this.wrapLabel = new WrapButtonLabel(string);
        this.wrapLabel.setFont(abstractButton.getFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ((GridBagLayout)this.getLayout()).setConstraints(this.wrapLabel, gridBagConstraints);
        this.add(this.wrapLabel);
        this.wrapLabel.addMouseListener(this);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.button.setEnabled(bl);
        this.wrapLabel.setEnabled(bl);
    }

    public void requestFocus() {
        Debug.trace((String)"WrapButton.requestFocus()");
        this.button.requestFocus();
    }

    public boolean isFocusable() {
        return true;
    }

    public void removeNotify() {
        super.removeNotify();
        this.wrapLabel.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.clicked = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.overObj) {
            this.button.doClick();
        }
        this.clicked = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.overObj = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.overObj = false;
    }

    public boolean isSelected() {
        return this.button.isSelected();
    }

    public void setSelected(boolean bl) {
        this.button.setSelected(bl);
    }

    public AbstractButton getButton() {
        return this.button;
    }

    public void addToGroup(ButtonGroup buttonGroup) {
        buttonGroup.add(this.button);
    }

    public class WrapButtonLabel
    extends JComponent {
        private JLabel label;
        private JTextPane textPane;

        public WrapButtonLabel(String string) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.label = new JLabel("");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(this.label, gridBagConstraints);
            this.add(this.label);
            this.textPane = new JTextPane();
            this.textPane.setHighlighter(null);
            this.textPane.setSelectedTextColor(null);
            this.textPane.setEditable(false);
            this.textPane.setOpaque(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(this.textPane, gridBagConstraints);
            this.add(this.textPane);
            this.setFont(DEFAULT_LABEL_FONT);
            this.setText(string);
        }

        public String getText() {
            return this.textPane.getText();
        }

        public void setText(String string) {
            if (string == null) {
                this.textPane.setText("");
                NConeFactory.novellJEditorPane((JEditorPane)this.textPane, (String)"", (String)"");
                return;
            }
            this.textPane.setText(string);
            NConeFactory.novellJEditorPane((JEditorPane)this.textPane, (String)Loc.removeHotChar((String)string), (String)"");
            int n = string.indexOf("&");
            if (n == -1 || string.length() - 1 <= n) {
                return;
            }
            this.textPane.setText("");
            int n2 = string.length();
            char c = string.charAt(n + 1);
            WrapButton.this.button.setMnemonic(c);
            String[] stringArray = new String[]{string.substring(0, n), string.substring(n + 1, n + 2), string.substring(n + 2, n2)};
            String[] stringArray2 = new String[]{"myRegularStyle", "myUnderlineStyle", "myRegularStyle"};
            Style style = StyleContext.getDefaultStyleContext().getStyle("default");
            Style style2 = this.textPane.addStyle("myRegularStyle", style);
            StyleConstants.setFontFamily(style, "SansSerif");
            Style style3 = this.textPane.addStyle("myUnderlineStyle", style2);
            StyleConstants.setUnderline(style3, true);
            Document document = this.textPane.getDocument();
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    document.insertString(document.getLength(), string2, this.textPane.getStyle(stringArray2[i]));
                }
            }
            catch (BadLocationException badLocationException) {
                Debug.traceDlg((String)("WrapButtonLabel.setText: ex= " + badLocationException));
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public void setEnabled(boolean bl) {
            this.label.setEnabled(bl);
            this.textPane.setEnabled(bl);
            if (bl) {
                this.textPane.setForeground(Color.black);
            } else {
                this.textPane.setForeground(Color.gray);
            }
        }
    }
}

