/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ds.values;

import com.novell.gw.util.Comparable;
import com.novell.gw.util.EngineResource;
import com.novell.gw.util.Matchable;
import com.novell.gw.util.NotComparableException;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.schema.SchemaNumber;
import java.io.Serializable;

public class IntegerValue
implements SchemaNumber,
Comparable,
Matchable,
Cloneable,
Serializable {
    protected int value;

    public IntegerValue() {
        this.value = 0;
    }

    public IntegerValue(int n) {
        this.value = n;
    }

    public IntegerValue(IntegerValue integerValue) {
        this.value = integerValue.value;
    }

    public Object clone() {
        return new IntegerValue(this.value);
    }

    public int compareTo(Object object) throws Exception {
        return this.compare(object);
    }

    public boolean equals(Object object) {
        if (object instanceof IntegerValue) {
            return this.value == ((IntegerValue)object).intValue();
        }
        return false;
    }

    public String getName() {
        return "";
    }

    public String getSyntaxId() {
        return "";
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int compare(Object object) throws NotComparableException {
        if (object instanceof IntegerValue) {
            int n = ((IntegerValue)object).intValue();
            return this.value > n ? 1 : (this.value < n ? -1 : 0);
        }
        throw new IllegalArgumentException(EngineResource.getString("NotIntegerValueInstance"));
    }

    public boolean matches(String string) {
        return false;
    }

    public boolean matches(int n, Object object) {
        if (object instanceof Integer) {
            return SearchStringComponent.compareInt((int)n, (int)((Integer)object), (int)this.value);
        }
        if (object instanceof String) {
            try {
                return SearchStringComponent.compareInt((int)n, (int)Integer.parseInt((String)object), (int)this.value);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(object.toString());
            }
        }
        if (object instanceof SchemaNumber) {
            return SearchStringComponent.compareInt((int)n, (int)((SchemaNumber)object).intValue(), (int)this.value);
        }
        throw new IllegalArgumentException(object.toString());
    }
}

