/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ds.values;

import com.novell.gw.ds.SearchSupport;
import com.novell.gw.util.Comparable;
import com.novell.gw.util.EngineResource;
import com.novell.gw.util.Matchable;
import com.novell.gw.util.NotComparableException;
import com.novell.service.schema.SchemaSequence;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class OctetStringValue
implements SchemaSequence,
Comparable,
Matchable,
Cloneable,
Serializable {
    protected byte[] value;

    public OctetStringValue() {
        this.value = new byte[0];
    }

    public OctetStringValue(byte[] byArray) {
        this.value = (byte[])byArray.clone();
    }

    public OctetStringValue(OctetStringValue octetStringValue) {
        this.value = (byte[])octetStringValue.value.clone();
    }

    public Object clone() {
        return new OctetStringValue(this.value);
    }

    public byte[] getBytes() {
        return this.value;
    }

    public int compareTo(Object object) throws Exception {
        return this.compare(object);
    }

    public boolean equals(Object object) {
        if (object instanceof OctetStringValue) {
            OctetStringValue octetStringValue = (OctetStringValue)object;
            try {
                if (this.value.length == octetStringValue.count()) {
                    return this.compareTo(object) == 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return false;
    }

    public String getName() {
        return "";
    }

    public String getSyntaxId() {
        return "";
    }

    public int count() {
        return this.value.length;
    }

    public Enumeration getValues() {
        Vector<Byte> vector = new Vector<Byte>(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            vector.addElement(new Byte(this.value[i]));
        }
        return vector.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.value != null) {
            for (int i = 0; i < this.value.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(' ');
                }
                int n = this.value[i] & 0xFF;
                stringBuffer.append(Integer.toHexString(n).toUpperCase());
            }
        }
        return stringBuffer.toString();
    }

    public int compare(Object object) throws NotComparableException {
        if (object instanceof OctetStringValue) {
            return SearchSupport.compareBytes(this.value, ((OctetStringValue)object).getBytes());
        }
        throw new IllegalArgumentException(EngineResource.getString("NotOctetStringValueInstance"));
    }

    public boolean matches(String string) {
        return false;
    }

    public boolean matches(int n, Object object) {
        if (object instanceof byte[]) {
            return SearchSupport.compareBytes(n, (byte[])object, this.value);
        }
        if (object instanceof OctetStringValue) {
            return SearchSupport.compareBytes(n, ((OctetStringValue)object).getBytes(), this.value);
        }
        throw new IllegalArgumentException(object.toString());
    }
}

