/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class AttributesWrap {
    private Attributes attrs = null;

    public AttributesWrap(Attributes attributes) {
        this.attrs = attributes;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public Integer getInteger(String string) {
        Integer n = null;
        try {
            Attribute attribute = this.attrs.get(string);
            if (attribute != null) {
                n = (Integer)attribute.get();
            }
        }
        catch (NamingException namingException) {
            Debug.traceException(namingException);
        }
        return n;
    }

    public int getInt(String string) {
        Integer n = this.getInteger(string);
        if (n == null) {
            if (Debug.trace) {
                Debug.trace("AttributesWrap.getInt: NULL value - returning -1");
            }
            return -1;
        }
        return n;
    }

    public String getString(String string) {
        String string2 = null;
        try {
            Attribute attribute = this.attrs.get(string);
            if (attribute != null) {
                string2 = (String)attribute.get();
            }
        }
        catch (NamingException namingException) {
            Debug.traceException(namingException);
        }
        return string2;
    }

    public Object getObject(String string) {
        Object object = null;
        try {
            Attribute attribute = this.attrs.get(string);
            if (attribute != null) {
                object = attribute.get();
            }
        }
        catch (NamingException namingException) {
            Debug.traceException(namingException);
        }
        return object;
    }

    public void putObject(String string, Object object) {
        if (object == null) {
            this.attrs.remove(string);
        } else {
            this.attrs.put(string, object);
        }
    }

    public String toString() {
        String string = "AttributesWrap: ";
        try {
            NamingEnumeration<? extends Attribute> namingEnumeration = this.attrs.getAll();
            while (namingEnumeration.hasMore()) {
                string = string + "\n" + namingEnumeration.next();
            }
        }
        catch (NamingException namingException) {
            Debug.traceException(namingException);
        }
        return string;
    }
}

