/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.AssertionFailureException;
import com.novell.gw.util.PostconditionFailureException;
import com.novell.gw.util.PreconditionFailureException;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class Debug {
    private static final String TIMESTAMP = "com.novell.gw.util.Debug.code";
    private static final String TRACE = "com.novell.gw.util.Debug.trace";
    private static final String TRACE_DLG = "com.novell.gw.util.Debug.trace.dialog";
    private static final String ASSERT = "com.novell.gw.util.Debug.assert";
    private static final String ASSERT_DLG = "com.novell.gw.util.Debug.assert.dialog";
    private static final String STACK_TRACE = "com.novell.gw.util.Debug.stackTrace";
    private static final String THREAD_TRACE = "com.novell.gw.util.Debug.trace.thread";
    private static final String GUI = "com.novell.gw.util.Debug.gui";
    private static final String lineSeparator = System.getProperty("line.separator");
    public static final boolean trace;
    private static final boolean traceDlg;
    public static final boolean assrtTag;
    private static final boolean assrtDlg;
    private static final boolean stackTrace;
    private static final boolean traceThreads;
    private static final boolean gui;
    private static final long timestamp;
    private static final Object lock;
    private static final PrintWriter debugStream;
    private static final Stack traceContext;
    private static final String TRACE_PREFIX = "";
    private static final String INDENT = "   ";
    private static final String EXCEPTION_HEADER = "============== Exception (begin) ===========================";
    private static final String EXCEPTION_FOOTER = "============== Exception (end) =============================";
    private static final String SEPARATOR = "============================================================";

    private static Properties loadProperties(String string) {
        Properties properties = null;
        Debug debug = new Debug();
        InputStream inputStream = debug.getClass().getResourceAsStream("/" + string);
        if (inputStream != null) {
            Properties properties2 = new Properties();
            properties2.put(TRACE, System.getProperty(TRACE, "false"));
            properties2.put(TRACE_DLG, System.getProperty(TRACE_DLG, "false"));
            properties2.put(ASSERT, System.getProperty(ASSERT, "false"));
            properties2.put(ASSERT_DLG, System.getProperty(ASSERT_DLG, "false"));
            properties2.put(STACK_TRACE, System.getProperty(STACK_TRACE, "false"));
            properties2.put(THREAD_TRACE, System.getProperty(THREAD_TRACE, "false"));
            properties2.put(GUI, System.getProperty(GUI, "false"));
            try {
                properties = new Properties(properties2);
                properties.load(new BufferedInputStream(inputStream));
            }
            catch (IOException iOException) {
                properties = null;
                System.out.println("Debug.loadProperties: ex= " + iOException);
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(String string) {
        if (trace) {
            boolean bl = false;
            Object object = lock;
            synchronized (object) {
                if (!traceContext.empty()) {
                    bl = true;
                    Vector vector = (Vector)traceContext.peek();
                    vector.addElement(Debug.getTraceHeader() + string);
                }
            }
            if (!bl) {
                object = lock;
                synchronized (object) {
                    debugStream.print(Debug.getTraceHeader() + string + lineSeparator);
                    debugStream.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(String string) {
        if (trace) {
            boolean bl = false;
            Object object = lock;
            synchronized (object) {
                if (!traceContext.empty()) {
                    bl = true;
                    Vector vector = (Vector)traceContext.peek();
                    vector.addElement(Debug.getTraceHeader() + string);
                }
            }
            if (!bl) {
                object = lock;
                synchronized (object) {
                    debugStream.print(string);
                    debugStream.flush();
                }
            }
        }
    }

    public static void traceDlg(Component component, String string) {
        Debug.trace(string);
        if (traceDlg) {
            new JButton().getToolkit().beep();
            JOptionPane.showMessageDialog(component, Debug.getTraceHeader() + string, "Debug.traceDlg", 2);
        }
    }

    public static void traceDlg(String string) {
        Debug.traceDlg(null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(Object object) {
        if (trace) {
            boolean bl = false;
            String string = object == null ? "null" : object.toString();
            Object object2 = lock;
            synchronized (object2) {
                if (!traceContext.empty()) {
                    bl = true;
                    Vector vector = (Vector)traceContext.peek();
                    vector.addElement(Debug.getTraceHeader() + string);
                }
            }
            if (!bl) {
                object2 = lock;
                synchronized (object2) {
                    debugStream.print(Debug.getTraceHeader() + string + lineSeparator);
                    debugStream.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceException(Throwable throwable, String string) {
        if (!trace && !stackTrace) {
            return;
        }
        if (throwable == null) {
            return;
        }
        boolean bl = Debug.exitContext();
        Object object = lock;
        synchronized (object) {
            if (trace) {
                debugStream.print(EXCEPTION_HEADER + lineSeparator);
                debugStream.flush();
            }
            if (stackTrace) {
                if (string != null) {
                    debugStream.print("[message: " + string + "]" + lineSeparator);
                    debugStream.flush();
                }
                throwable.printStackTrace(debugStream);
            } else if (trace) {
                debugStream.print(Debug.getThreadTrace() + " " + throwable + lineSeparator);
                debugStream.flush();
                if (string != null) {
                    debugStream.print("[message: " + string + "]" + lineSeparator);
                    debugStream.flush();
                }
            }
            if (trace) {
                debugStream.print(EXCEPTION_FOOTER + lineSeparator);
                debugStream.flush();
            }
        }
        if (bl) {
            Debug.enterContext();
        }
    }

    private static void traceProperties(String string, Properties properties) {
        if (trace) {
            if (string != null) {
                Debug.trace(string);
            }
            Debug.dump(properties);
            Debug.trace(TRACE_PREFIX);
        }
    }

    public static void traceException(Throwable throwable) {
        Debug.traceException(throwable, null);
    }

    public static void assrt(boolean bl, String string) {
        Debug.assrt(null, bl, string);
    }

    public static void assrt(Component component, boolean bl, String string) {
        if (bl) {
            return;
        }
        Debug.trace("Debug.assrt: " + string);
        if (assrtDlg) {
            new JButton().getToolkit().beep();
            JOptionPane.showMessageDialog(component, string, "Assert Failed", 0);
        }
        if (assrtTag) {
            throw new AssertionFailureException(string);
        }
    }

    public static void assrtPrecondition(boolean bl, String string) {
        if (assrtTag) {
            if (!bl) {
                throw new PreconditionFailureException(string);
            }
        } else if (!bl) {
            Debug.trace(string);
        }
    }

    public static void assrtPostcondition(boolean bl, String string) {
        if (assrtTag) {
            if (!bl) {
                throw new PostconditionFailureException(string);
            }
        } else if (!bl) {
            Debug.trace(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterContext(String string) {
        if (!trace) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        Object object = lock;
        synchronized (object) {
            traceContext.push(vector);
        }
        if (string != null) {
            vector.addElement(Debug.getTraceHeader() + string);
        }
    }

    private static void enterContext() {
        Debug.enterContext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exitContext(String string) {
        if (!trace) {
            return false;
        }
        Vector vector = null;
        boolean bl = false;
        Object object = lock;
        synchronized (object) {
            if (!traceContext.empty()) {
                vector = (Vector)traceContext.pop();
                bl = true;
            }
        }
        if (vector != null) {
            Debug.trace(vector);
        }
        return bl;
    }

    private static boolean exitContext() {
        return Debug.exitContext(null);
    }

    private static void exitAllContext() {
        while (Debug.exitContext()) {
        }
    }

    private static String getTraceHeader() {
        StringBuffer stringBuffer = new StringBuffer(TRACE_PREFIX);
        int n = Debug.getIndentLevel(Thread.currentThread().getName());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(INDENT);
        }
        if (traceThreads) {
            stringBuffer.append("<" + Debug.getThreadTrace() + "> ");
        }
        return stringBuffer.toString();
    }

    private static String getThreadTrace() {
        return Thread.currentThread().getName();
    }

    public static void separator() {
        Debug.trace(SEPARATOR);
    }

    private static int getIndentLevel(String string) {
        if (trace) {
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void trace(Vector vector) {
        Object object = lock;
        synchronized (object) {
            debugStream.print(SEPARATOR + lineSeparator);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                debugStream.print((String)enumeration.nextElement() + lineSeparator);
            }
            debugStream.print(SEPARATOR + lineSeparator);
            debugStream.flush();
        }
    }

    public static String dumpString() {
        return "gw.util.Debug\n timestamp = " + timestamp + "\n trace     = " + trace + "\n traceDlg  = " + traceDlg + "\n assrtTag  = " + assrtTag + "\n assrtDlg  = " + assrtDlg + "\n stackTrace= " + stackTrace;
    }

    static {
        lock = new Object();
        debugStream = new PrintWriter(System.out, true);
        traceContext = new Stack();
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        Properties properties = Debug.loadProperties("debug.properties");
        if (properties != null) {
            int n = 0;
            int n2 = 0;
            if (properties.containsKey(TIMESTAMP)) {
                n = 1;
                l = Long.valueOf(properties.getProperty(TIMESTAMP));
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT-8:00"));
                long l2 = gregorianCalendar.getTime().getTime() / 1000L;
                if (l2 <= l) {
                    gregorianCalendar.setTime(new Date(l * 1000L));
                    n2 = gregorianCalendar.get(5);
                    if (n2 == 13) {
                        n = 2;
                    }
                }
            }
            switch (n) {
                case 2: {
                    System.out.println("GroupWise Administration debugging is ON.");
                    if (properties.containsKey(TRACE)) {
                        bl = Boolean.valueOf(properties.getProperty(TRACE));
                    }
                    if (properties.containsKey(TRACE_DLG)) {
                        bl2 = Boolean.valueOf(properties.getProperty(TRACE_DLG));
                    }
                    if (properties.containsKey(ASSERT)) {
                        bl3 = Boolean.valueOf(properties.getProperty(ASSERT));
                    }
                    if (properties.containsKey(ASSERT_DLG)) {
                        bl4 = Boolean.valueOf(properties.getProperty(ASSERT_DLG));
                    }
                    if (properties.containsKey(STACK_TRACE)) {
                        bl5 = Boolean.valueOf(properties.getProperty(STACK_TRACE));
                    }
                    if (properties.containsKey(THREAD_TRACE)) {
                        bl6 = Boolean.valueOf(properties.getProperty(THREAD_TRACE));
                    }
                    if (!properties.containsKey(GUI)) break;
                    bl7 = Boolean.valueOf(properties.getProperty(GUI));
                    break;
                }
                case 1: {
                    System.out.println("GroupWise Administration debugging is OFF - invalid code: " + l + ", " + n2);
                    break;
                }
                default: {
                    System.out.println("GroupWise Administration debugging is OFF - no code.");
                }
            }
        }
        timestamp = l;
        trace = bl;
        traceDlg = bl2;
        assrtTag = bl3;
        assrtDlg = bl4;
        stackTrace = bl5;
        traceThreads = bl6;
        gui = bl7;
    }
}

