/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;

public class Dho {
    private static final String DHO_SEP = ".";
    private static final String DHO_AT = "@";
    private String sDomain;
    private String sHost;
    private String sObject;

    public Dho() {
    }

    public Dho(Dho dho) {
        this.setDho(dho);
    }

    public Dho(String string) {
        this.Parse(string);
    }

    public Dho(String string, String string2, String string3) {
        this.sDomain = string;
        this.sHost = string2;
        this.sObject = string3;
    }

    public void setDho(Dho dho) {
        if (dho == null) {
            this.sObject = null;
            this.sHost = null;
            this.sDomain = null;
            return;
        }
        this.sDomain = dho.getDomain();
        this.sHost = dho.getHost();
        this.sObject = dho.getObject();
    }

    public void setDho(String string) {
        this.Parse(string);
    }

    public void setDomain(String string) {
        this.sDomain = string;
    }

    public void setHost(String string) {
        this.sHost = string;
    }

    public void setObject(String string) {
        this.sObject = string;
    }

    public String getAddress() {
        String string = "";
        if (this.sDomain != null && this.sDomain.length() > 0 && this.sHost != null && this.sHost.length() > 0 && this.sObject != null && this.sObject.length() > 0) {
            string = this.sObject + DHO_AT + this.sDomain + DHO_SEP + this.sHost;
        }
        return string;
    }

    public String toString() {
        if (this.sDomain == null || this.sDomain.length() == 0) {
            return new String();
        }
        if (this.sHost == null || this.sHost.length() == 0) {
            return new String(this.sDomain);
        }
        if (this.sObject == null || this.sObject.length() == 0) {
            return new String(this.sDomain + DHO_SEP + this.sHost);
        }
        return new String(this.sDomain + DHO_SEP + this.sHost + DHO_SEP + this.sObject);
    }

    public String getDomain() {
        return this.sDomain != null ? this.sDomain : new String();
    }

    public String getHost() {
        return this.sHost != null ? this.sHost : new String();
    }

    public String getObject() {
        return this.sObject != null ? this.sObject : new String();
    }

    public String getDh() {
        if (this.sDomain != null && this.sHost != null) {
            return this.sDomain + DHO_SEP + this.sHost;
        }
        Debug.trace("Dho.getDh: returning blank string.");
        return "";
    }

    public boolean isEmpty() {
        return this.toString().length() == 0;
    }

    private void Parse(String string) {
        this.sObject = null;
        this.sHost = null;
        this.sDomain = null;
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.indexOf(DHO_AT);
        int n2 = string.indexOf(DHO_AT, n + 1);
        int n3 = string.indexOf(DHO_SEP);
        int n4 = string.indexOf(DHO_SEP, n3 + 1);
        if (n != -1 && n3 != -1 && n < n3 && n2 == -1 && n4 == -1) {
            this.sObject = string.substring(0, n);
            this.sDomain = string.substring(n + 1, n3);
            this.sHost = string.substring(n3 + 1);
            return;
        }
        if (n3 == -1) {
            this.sDomain = string;
            return;
        }
        this.sDomain = string.substring(0, n3);
        if (n4 == -1) {
            this.sHost = string.substring(n3 + 1);
            return;
        }
        this.sHost = string.substring(n3 + 1, n4);
        this.sObject = string.substring(n4 + 1);
    }
}

