/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.gw.util.Debug;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;

public class GwTextFileWriter {
    public static final String EOL = "\r\n";
    private Vector vec;
    private File file;
    private boolean alreadyClosed = false;

    public GwTextFileWriter(File file) {
        this.file = file;
        this.vec = new Vector(100, 100);
    }

    public void writeLine(String string) {
        this.vec.addElement(string);
    }

    public void close() {
        if (this.alreadyClosed) {
            Debug.trace("GwTextFileWriter.close: ALREADY CLOSED");
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i < this.vec.size(); ++i) {
                String string = (String)this.vec.elementAt(i) + EOL;
                bufferedWriter.write(string, 0, string.length());
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            Debug.trace("GwTextFileWriter: ex= " + exception);
            Debug.traceException(exception);
        }
        this.alreadyClosed = true;
    }

    public String toString() {
        String string = "GwTextFileWriter: " + this.file;
        if (this.vec == null) {
            return string + "\n NULL";
        }
        if (this.vec.size() == 0) {
            return string + "\n <empty>";
        }
        for (int i = 0; i < this.vec.size(); ++i) {
            string = string + "\n" + (String)this.vec.elementAt(i);
        }
        return string;
    }
}

