/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.util;

import com.novell.application.console.snapin.NConeFactory;
import com.novell.gw.util.Debug;
import com.novell.gw.util.Misc;
import com.novell.utility.localization.Loc;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Resource {
    private static final Resource colonRes = Resource.getBundle("com.novell.gw.util.EngineResource");
    public static final String COLON_STR = colonRes.getString2("colon");
    protected ResourceBundle bundle;

    public static Resource getBundle(String string) throws RuntimeException {
        try {
            Locale locale = Locale.getDefault();
            return Resource.getBundle(string, locale);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (Debug.trace) {
                Debug.traceException(throwable);
            }
            throw new MissingResourceException("", "", string);
        }
    }

    public static Resource getBundle(String string, Locale locale) throws RuntimeException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        return new Resource(resourceBundle);
    }

    private Resource(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getString(String string) throws RuntimeException {
        try {
            String string2 = this.bundle.getString(string);
            if (string2 == null) {
                String string3 = "Key \"" + string + "\" not found";
                throw new MissingResourceException(string3, "", string);
            }
            return string2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (Debug.trace) {
                Debug.traceException(throwable);
            }
            throw new MissingResourceException("", "", string);
        }
    }

    public Enumeration getKeys() {
        return this.bundle.getKeys();
    }

    public String getString2(String string) {
        String string2;
        Throwable throwable = null;
        if (string == null) {
            throwable = new Throwable();
            Debug.trace("Resource.getString2: NULL reference passed in.");
            string2 = "1-BAD STRING from Resource.getString2";
        } else {
            try {
                string2 = this.bundle.getString(string);
                if (string2 == null) {
                    throwable = new Throwable();
                    Debug.trace("Resource.getString2: NULL returned from getProperty().");
                    string2 = "2-BAD STRING from Resource.getString2";
                }
            }
            catch (MissingResourceException missingResourceException) {
                throwable = missingResourceException;
                Debug.trace("Resource.getString2: mrex= " + missingResourceException);
                string2 = "3-BAD STRING from Resource.getString2";
            }
        }
        if (throwable != null) {
            Debug.traceException(throwable);
            Debug.traceDlg("No resource string for reference [" + string + "]\n" + string2);
        }
        return string2;
    }

    public String getStringWithColon(String string) {
        String string2 = this.getString2(string);
        if (!string2.endsWith(COLON_STR)) {
            string2 = string2 + COLON_STR;
        }
        return string2;
    }

    public String getStringWithoutColon(String string) {
        String string2 = this.getString2(string);
        if (string2.endsWith(COLON_STR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public String putStringInFormat(String string, String string2, String string3, String string4) {
        String string5 = this.getString2(string);
        if (string5 == null) {
            new Throwable().printStackTrace();
            Debug.traceDlg("Resource.putStringInFormat: NULL base - using YYYYY");
            string5 = "YYYYY {0}";
        }
        Object[] objectArray = new Object[]{string2, string3, string4};
        return MessageFormat.format(string5, objectArray);
    }

    public String putStringInFormat(String string, Object[] objectArray) {
        String string2 = this.getString2(string);
        if (string2 == null) {
            new Throwable().printStackTrace();
            Debug.traceDlg("Resource.putStringInFormat: NULL base - using YYYYY");
            string2 = "YYYYY {0}";
        }
        return MessageFormat.format(string2, objectArray);
    }

    public String putStringInFormat(String string, String string2) {
        return this.putStringInFormat(string, string2, null, null);
    }

    public int getResourceInt(String string, int n) {
        String string2 = null;
        if (this.bundle != null) {
            string2 = this.getString2(string);
        }
        return Misc.parseInt2(string2, n);
    }

    public JRadioButton getRadioButton(String string) {
        String string2 = this.getString2(string);
        JRadioButton jRadioButton = NConeFactory.novellJRadioButton((JRadioButton)new JRadioButton(), (String)Loc.removeHotChar((String)string2), (String)"");
        Loc.setText((AbstractButton)jRadioButton, (String)string2);
        return jRadioButton;
    }

    public JCheckBox getCheckBox(String string) {
        String string2 = this.getString2(string);
        JCheckBox jCheckBox = NConeFactory.novellJCheckBox((JCheckBox)new JCheckBox(), (String)Loc.removeHotChar((String)string2), (String)"");
        Loc.setText((AbstractButton)jCheckBox, (String)string2);
        return jCheckBox;
    }

    public JLabel getLabel(String string) {
        String string2 = Loc.removeHotChar((String)this.getString2(string));
        JLabel jLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string2), (String)string2, (String)"");
        return jLabel;
    }

    public JLabel getLabel(String string, Component component) {
        String string2 = this.getString2(string);
        JLabel jLabel = NConeFactory.novellJLabel((JLabel)new JLabel(string2), (String)Loc.removeHotChar((String)string2), (String)"");
        if (component != null) {
            if (component instanceof JTextField) {
                NConeFactory.makeRelation((JLabel)jLabel, (JTextField)((JTextField)component));
            }
            Loc.setText((JLabel)jLabel, (Component)component, (String)string2);
        }
        return jLabel;
    }

    public JMenu getMenu(String string) {
        String string2 = this.getString2(string);
        JMenu jMenu = NConeFactory.novellJMenu((JMenu)new JMenu(), (String)Loc.removeHotChar((String)string2), (String)"");
        Loc.setText((AbstractButton)jMenu, (String)string2);
        return jMenu;
    }

    public JMenuItem getMenuItem(String string) {
        String string2 = this.getString2(string);
        JMenuItem jMenuItem = NConeFactory.novellJMenuItem((JMenuItem)new JMenuItem(), (String)Loc.removeHotChar((String)string), (String)"");
        Loc.setText((AbstractButton)jMenuItem, (String)string2);
        return jMenuItem;
    }

    public void setMenuItem(JMenuItem jMenuItem, String string) {
        String string2 = this.getString2(string);
        NConeFactory.novellJMenuItem((JMenuItem)jMenuItem, (String)Loc.removeHotChar((String)string), (String)"");
        Loc.setText((AbstractButton)jMenuItem, (String)string2);
    }

    public JCheckBoxMenuItem getCheckBoxMenuItem(String string) {
        String string2 = this.getString2(string);
        JCheckBoxMenuItem jCheckBoxMenuItem = NConeFactory.novellJCheckBoxMenuItem((JCheckBoxMenuItem)new JCheckBoxMenuItem(), (String)Loc.removeHotChar((String)string2), (String)"");
        Loc.setText((AbstractButton)jCheckBoxMenuItem, (String)string2);
        return jCheckBoxMenuItem;
    }
}

