/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.common.util;

import com.novell.admin.common.util.EndianOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EndianOutputStream
extends DataOutputStream
implements EndianOutput {
    public final void writeHiLoChars(String string) throws IOException {
        this.writeChars(string);
        this.writeChar(0);
    }

    public final void writeLoHiChars(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            outputStream.write(c & 0xFF);
            outputStream.write(c >>> 8 & 0xFF);
            ++n2;
        }
        this.written += n * 2;
        this.writeChar(0);
    }

    public final void writeHiLoInt(int n) throws IOException {
        this.writeInt(n);
    }

    public final void writeLoHiInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 24 & 0xFF);
        this.written += 4;
    }

    public final void writeHiLoShort(int n) throws IOException {
        this.writeShort(n);
    }

    public final void writeLoHiShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeHiLoLong(long l) throws IOException {
        this.writeLong(l);
    }

    public final void writeLoHiLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)l & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void pad(int n) throws IOException {
        OutputStream outputStream = this.out;
        int n2 = this.written % n;
        int n3 = 0;
        while (n3 < n2) {
            outputStream.write(0);
            ++n3;
        }
        this.written += n2;
    }

    public EndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

