/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.BooleanValue;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class BooleanStrategy
implements ValueStrategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    private static final int BAD_TOSTRING_OBJ = 3;
    private static final int BAD_BOUNDS_OBJ = 4;

    public boolean canCreateValue(Object object) {
        return object instanceof Boolean || object instanceof String;
    }

    public ValueComponent createValueComponent() {
        return new BooleanValue(this.getSyntax(), new Boolean(true));
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof Boolean) {
            return new BooleanValue(this.getSyntax(), (Boolean)object);
        }
        if (object instanceof String) {
            return new BooleanValue(this.getSyntax(), new Boolean((String)object));
        }
        throw new ComponentCreationException();
    }

    public boolean equals(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof BooleanValue) {
            if (valueComponent.getSyntax() == valueComponent2.getSyntax()) {
                BooleanValue booleanValue = (BooleanValue)valueComponent;
                BooleanValue booleanValue2 = (BooleanValue)valueComponent2;
                return booleanValue.getValue() == booleanValue2.getValue();
            }
        } else {
            throw new AdminError(1, this.getClass());
        }
        return false;
    }

    public long compare(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof BooleanValue && valueComponent2 instanceof BooleanValue) {
            if (valueComponent.getSyntax() != valueComponent2.getSyntax()) {
                return valueComponent.getSyntax().getId() - valueComponent2.getSyntax().getId();
            }
            BooleanValue booleanValue = (BooleanValue)valueComponent;
            BooleanValue booleanValue2 = (BooleanValue)valueComponent2;
            boolean bl = booleanValue.getValue();
            boolean bl2 = booleanValue2.getValue();
            long l = 0L;
            if (!bl && bl2) {
                l = -1L;
            } else if (bl && !bl2) {
                l = 1L;
            }
            return l;
        }
        throw new AdminError(2, this.getClass());
    }

    public String toString(ValueComponent valueComponent) {
        if (valueComponent instanceof BooleanValue) {
            return ((BooleanValue)valueComponent).getBooleanValue().toString();
        }
        throw new AdminError(3, this.getClass());
    }

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof BooleanValue) {
            return false;
        }
        throw new AdminError(4, this.getClass());
    }

    public abstract Syntax getSyntax();
}

