/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NSUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassDefinition
implements Serializable {
    protected Hashtable mandatoryAttributeTable;
    protected Hashtable optionalAttributeTable;
    protected Hashtable namingAttributeTable = null;
    protected Vector classContainmentNameVec = null;
    protected String className;
    protected boolean container = false;
    protected boolean effective = true;
    protected boolean nonRemove = false;
    protected boolean auxiliary = false;

    public String getName() {
        return this.className;
    }

    public AttributeDefinition[] getMandatoryAttributes() {
        Object[] objectArray = new AttributeDefinition[this.mandatoryAttributeTable.size()];
        NSUtil.copyIntoArray(this.mandatoryAttributeTable, objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getOptionalAttributes() {
        Object[] objectArray = new AttributeDefinition[this.optionalAttributeTable.size()];
        NSUtil.copyIntoArray(this.optionalAttributeTable, objectArray);
        return objectArray;
    }

    public AttributeDefinition[] getNamingAttributes() {
        Object[] objectArray = new AttributeDefinition[this.namingAttributeTable.size()];
        NSUtil.copyIntoArray(this.namingAttributeTable, objectArray);
        return objectArray;
    }

    public boolean isNamedBy(String string) {
        return this.namingAttributeTable.containsKey(string);
    }

    public String[] getContainmentClasses() {
        Object[] objectArray = new String[this.classContainmentNameVec.size()];
        this.classContainmentNameVec.copyInto(objectArray);
        return objectArray;
    }

    public boolean canBeContainedBy(String string) {
        return this.classContainmentNameVec.contains(string);
    }

    public boolean isContainer() {
        return this.container;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public boolean isNonRemoveable() {
        return this.nonRemove;
    }

    public boolean isAuxiliary() {
        return this.auxiliary;
    }

    public boolean isAttributeMandatory(String string) {
        return this.mandatoryAttributeTable.containsKey(string);
    }

    public boolean isAttributeOptional(String string) {
        return this.optionalAttributeTable.containsKey(string);
    }

    public boolean isClassUsingAttribute(String string) {
        return this.optionalAttributeTable.containsKey(string) || this.mandatoryAttributeTable.containsKey(string);
    }

    public String toString() {
        return this.className;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClassDefinition)) return false;
        ClassDefinition classDefinition = (ClassDefinition)object;
        if (this.getName().compareTo(classDefinition.getName()) != 0) {
            return false;
        }
        ClassDefinition classDefinition2 = classDefinition;
        synchronized (classDefinition2) {
            ClassDefinition classDefinition3 = this;
            synchronized (classDefinition3) {
                Object v;
                Object object2;
                if (classDefinition.mandatoryAttributeTable.size() != this.mandatoryAttributeTable.size()) return false;
                if (classDefinition.namingAttributeTable.size() != this.namingAttributeTable.size()) return false;
                if (classDefinition.classContainmentNameVec.size() != this.classContainmentNameVec.size()) return false;
                if (classDefinition.optionalAttributeTable.size() != this.optionalAttributeTable.size()) return false;
                Enumeration<Object> enumeration = this.mandatoryAttributeTable.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (AttributeDefinition)enumeration.nextElement();
                    v = classDefinition.mandatoryAttributeTable.get(((AttributeDefinition)object2).getName());
                    if (v == null) {
                        return false;
                    }
                    if (((AttributeDefinition)object2).equals((AttributeDefinition)v)) continue;
                    return false;
                }
                enumeration = this.optionalAttributeTable.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (AttributeDefinition)enumeration.nextElement();
                    v = classDefinition.optionalAttributeTable.get(((AttributeDefinition)object2).getName());
                    if (v == null) {
                        return false;
                    }
                    if (((AttributeDefinition)object2).equals((AttributeDefinition)v)) continue;
                    return false;
                }
                enumeration = this.namingAttributeTable.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (AttributeDefinition)enumeration.nextElement();
                    v = classDefinition.namingAttributeTable.get(((AttributeDefinition)object2).getName());
                    if (v == null) {
                        return false;
                    }
                    if (((AttributeDefinition)object2).equals((AttributeDefinition)v)) continue;
                    return false;
                }
                enumeration = this.classContainmentNameVec.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    boolean bl = classDefinition.classContainmentNameVec.contains(object2);
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public ClassDefinition(String string, String[] stringArray, AttributeDefinition[] attributeDefinitionArray, AttributeDefinition[] attributeDefinitionArray2, AttributeDefinition[] attributeDefinitionArray3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(string, stringArray, attributeDefinitionArray, attributeDefinitionArray2, attributeDefinitionArray3);
        this.container = bl;
        this.effective = bl2;
        this.nonRemove = bl3;
        this.auxiliary = bl4;
    }

    public ClassDefinition(String string, String[] stringArray, AttributeDefinition[] attributeDefinitionArray, AttributeDefinition[] attributeDefinitionArray2, AttributeDefinition[] attributeDefinitionArray3) {
        AttributeDefinition attributeDefinition;
        int n;
        AttributeDefinition[] attributeDefinitionArray4;
        this.className = string;
        if (attributeDefinitionArray != null) {
            attributeDefinitionArray4 = attributeDefinitionArray;
            synchronized (attributeDefinitionArray4) {
                this.mandatoryAttributeTable = new Hashtable(attributeDefinitionArray.length + 1);
                n = 0;
                while (n < attributeDefinitionArray.length) {
                    attributeDefinition = attributeDefinitionArray[n];
                    this.mandatoryAttributeTable.put(attributeDefinition.getName(), attributeDefinition);
                    ++n;
                }
            }
        } else {
            this.mandatoryAttributeTable = new Hashtable(1);
        }
        if (attributeDefinitionArray3 != null) {
            attributeDefinitionArray4 = attributeDefinitionArray3;
            synchronized (attributeDefinitionArray4) {
                this.optionalAttributeTable = new Hashtable(attributeDefinitionArray3.length + 1);
                n = 0;
                while (n < attributeDefinitionArray3.length) {
                    attributeDefinition = attributeDefinitionArray3[n];
                    this.optionalAttributeTable.put(attributeDefinition.getName(), attributeDefinition);
                    ++n;
                }
            }
        } else {
            this.optionalAttributeTable = new Hashtable(1);
        }
        if (attributeDefinitionArray2 == null) {
            this.namingAttributeTable = new Hashtable(1);
        } else {
            this.namingAttributeTable = new Hashtable(attributeDefinitionArray2.length + 1);
            int n2 = 0;
            while (n2 < attributeDefinitionArray2.length) {
                AttributeDefinition attributeDefinition2 = attributeDefinitionArray2[n2];
                this.namingAttributeTable.put(attributeDefinition2.getName(), attributeDefinition2);
                ++n2;
            }
        }
        if (stringArray != null) {
            this.classContainmentNameVec = new Vector(stringArray.length);
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.classContainmentNameVec.addElement(stringArray[n3]);
                ++n3;
            }
        } else {
            this.classContainmentNameVec = new Vector();
        }
    }
}

