/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ValueComponent;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DefaultNSObject
extends NSObject
implements Serializable {
    private static final int CANT_SET_CLASSDEF = 1;
    private static final int CANT_SET_CLASSDEF2 = 3;
    protected ObjectEntry objectEntry;
    protected Hashtable addedAttributeDefinitions = new Hashtable();
    protected AdminNamespace namespace = null;

    public void addAttribute(ObjectAttribute objectAttribute) throws NamespaceException {
        this.addAttribute(objectAttribute, false);
    }

    private void addAttribute(ObjectAttribute objectAttribute, boolean bl) throws NamespaceException {
        String string = objectAttribute.getName();
        this.checkAdd(objectAttribute, bl);
        if (objectAttribute.getComponentCount() == 0) {
            throw NamespaceException.ATTRIBUTE_NOT_VALUED;
        }
        this.attributes.put(string, objectAttribute);
        if (this.deletedAttributes.contains(string)) {
            this.deletedAttributes.removeElement(string);
            this.modifiedAttributes.addElement(string);
        } else if (!this.addedAttributes.contains(string)) {
            this.addedAttributes.addElement(string);
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, null, string);
        this.notifyPropertyChangeListeners(propertyChangeEvent);
    }

    public ObjectAttribute getAttribute(String string) {
        ObjectAttribute objectAttribute = null;
        Object v = this.attributes.get(string);
        if (v instanceof ObjectAttribute) {
            objectAttribute = (ObjectAttribute)v;
        } else if (v instanceof String) {
            try {
                String[] stringArray = new String[]{(String)v};
                ObjectAttribute[] objectAttributeArray = this.namespace.getAttributes(this.objectEntry, stringArray);
                if (objectAttributeArray.length > 0 && objectAttributeArray[0] != null) {
                    objectAttribute = objectAttributeArray[0];
                    this.attributes.put(string, objectAttribute);
                    objectAttribute.addPropertyChangeListener(this);
                } else {
                    this.attributes.remove(string);
                }
            }
            catch (NamespaceException namespaceException) {
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
        }
        return objectAttribute;
    }

    public boolean deleteAttribute(String string) throws NamespaceException {
        return this.deleteAttribute(string, false);
    }

    private boolean deleteAttribute(String string, boolean bl) throws NamespaceException {
        this.setClassDefinition();
        try {
            if (this.namespace.getAttributeDefinition(this.objectEntry, string).isReadOnly()) {
                throw NamespaceException.READONLY_ATTRIBUTE;
            }
        }
        catch (SPIException sPIException) {
            // empty catch block
        }
        if (!bl && this.isAttributeMandatory(string)) {
            throw NamespaceException.MANDATORY_ATTRIBUTE;
        }
        ObjectAttribute objectAttribute = this.getAttribute(string);
        if (objectAttribute == null) {
            return false;
        }
        if (!this.addedAttributes.removeElement(string)) {
            if (this.modifiedAttributes.removeElement(string)) {
                this.deletedAttributes.addElement(string);
            } else if (!this.deletedAttributes.contains(string)) {
                this.deletedAttributes.addElement(string);
                objectAttribute.removePropertyChangeListener(this);
            }
        }
        this.attributes.remove(string);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, string, null);
        this.notifyPropertyChangeListeners(propertyChangeEvent);
        return true;
    }

    public String[] getAddedAttributes() {
        Object[] objectArray = new String[this.addedAttributes.size()];
        this.addedAttributes.copyInto(objectArray);
        return objectArray;
    }

    public Hashtable getAddedAttributeDefinitions() {
        return this.addedAttributeDefinitions;
    }

    public String[] getAttributes() {
        Object[] objectArray = new String[this.attributes.size()];
        Enumeration enumeration = this.attributes.keys();
        Vector vector = new Vector(this.attributes.size());
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getMandatoryAttributes() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.attributes.keys();
        this.setClassDefinition();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.isAttributeMandatory((String)object)) continue;
            vector.addElement((Object[])object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String[] getOptionalAttributes() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>();
        Enumeration enumeration = this.attributes.keys();
        this.setClassDefinition();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!this.isAttributeOptional((String)object)) continue;
            vector.addElement((Object[])object);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public String[] getUnvaluedAttributes() {
        Vector<String> vector = new Vector<String>();
        this.setClassDefinition();
        AttributeDefinition[] attributeDefinitionArray = this.getOptionalAttributeDefinitions();
        int n = 0;
        while (n < attributeDefinitionArray.length) {
            ObjectAttribute objectAttribute = this.getAttribute(attributeDefinitionArray[n].getName());
            if (objectAttribute == null && !attributeDefinitionArray[n].isHidden()) {
                vector.addElement(attributeDefinitionArray[n].getName());
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ClassDefinition[] getClassDefinitions() {
        this.setClassDefinition();
        Object[] objectArray = new ClassDefinition[this.classDefinition.size()];
        this.classDefinition.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeletedAttributes() {
        Object[] objectArray = new String[this.deletedAttributes.size()];
        this.deletedAttributes.copyInto(objectArray);
        return objectArray;
    }

    public String[] getModifiedAttributes() {
        Object[] objectArray = new String[this.modifiedAttributes.size()];
        this.modifiedAttributes.copyInto(objectArray);
        return objectArray;
    }

    public ObjectEntry getObjectEntry() {
        return this.objectEntry;
    }

    public long getRevision() {
        return this.revision;
    }

    public NSObject clone(ObjectEntry objectEntry) throws NamespaceException {
        ObjectType[] objectTypeArray;
        ObjectType[] objectTypeArray2;
        DefaultNSObject defaultNSObject = null;
        if (objectEntry.getObjectType() == this.objectEntry.getObjectType() && (objectTypeArray2 = this.objectEntry.getSubTypes()).length == (objectTypeArray = objectEntry.getSubTypes()).length) {
            Vector<ObjectType> vector = new Vector<ObjectType>(objectTypeArray2.length);
            int n = 0;
            while (n < objectTypeArray2.length) {
                vector.addElement(objectTypeArray2[n]);
                ++n;
            }
            n = 0;
            while (n < objectTypeArray2.length) {
                if (!vector.contains(objectTypeArray[n])) {
                    throw NamespaceException.OBJECTTYPE_NOT_VALID;
                }
                ++n;
            }
            defaultNSObject = (DefaultNSObject)this.clone();
            defaultNSObject.objectEntry = objectEntry;
        }
        if (defaultNSObject == null) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        return defaultNSObject;
    }

    public boolean addAuxiliaryClassDefinition(ClassDefinition classDefinition, ObjectAttribute[] objectAttributeArray) throws NamespaceException {
        int n;
        boolean bl = true;
        Vector<Object> vector = new Vector<Object>();
        if (!classDefinition.isAuxiliary()) {
            throw NamespaceException.NOT_AUXILIARY_CLASS;
        }
        Object[] objectArray = classDefinition.getMandatoryAttributes();
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (this.attributes.get(objectArray[n2].getName()) == null) {
                vector.addElement(objectArray[n2]);
            }
            ++n2;
        }
        objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        if (!this.shadowSign && objectArray.length != 0) {
            if (objectAttributeArray != null && objectAttributeArray.length != 0) {
                Vector<AttributeDefinition> vector2 = new Vector<AttributeDefinition>(objectAttributeArray.length);
                n = 0;
                while (n < objectAttributeArray.length) {
                    vector2.addElement(objectAttributeArray[n].getAttributeDefinition());
                    ++n;
                }
                n = 0;
                while (n < objectArray.length) {
                    if (!vector2.contains(objectArray[n])) {
                        throw NamespaceException.MISSING_MANDATORY_ATTRIBUTE;
                    }
                    ++n;
                }
            } else {
                throw NamespaceException.MISSING_MANDATORY_ATTRIBUTE;
            }
        }
        this.setClassDefinition();
        AttributeDefinition[] attributeDefinitionArray = classDefinition.getMandatoryAttributes();
        n = 0;
        while (n < attributeDefinitionArray.length) {
            if (!this.isClassUsingAttribute(attributeDefinitionArray[n].getName())) {
                this.addedAttributeDefinitions.put(attributeDefinitionArray[n].getName(), attributeDefinitionArray[n].getName());
            }
            ++n;
        }
        AttributeDefinition[] attributeDefinitionArray2 = classDefinition.getOptionalAttributes();
        n = 0;
        while (n < attributeDefinitionArray2.length) {
            if (!this.isClassUsingAttribute(attributeDefinitionArray2[n].getName())) {
                this.addedAttributeDefinitions.put(attributeDefinitionArray2[n].getName(), attributeDefinitionArray2[n].getName());
            }
            ++n;
        }
        this.classDefinition.addElement(classDefinition);
        if (objectAttributeArray != null) {
            n = 0;
            while (n < objectAttributeArray.length) {
                try {
                    ObjectAttribute objectAttribute = this.getAttribute(objectAttributeArray[n].getName());
                    if (objectAttribute == null) {
                        this.addAttribute(objectAttributeArray[n], true);
                    } else {
                        if (objectAttribute.getAttributeDefinition().isSingleValued()) {
                            objectAttribute.removeAllComponents();
                        }
                        Enumeration enumeration = objectAttributeArray[n].getValueComponents();
                        while (enumeration.hasMoreElements()) {
                            objectAttribute.addComponent((ValueComponent)enumeration.nextElement());
                        }
                    }
                }
                catch (NamespaceException namespaceException) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean deleteAuxiliaryClassDefinition(ClassDefinition classDefinition) throws NamespaceException {
        boolean bl = false;
        if (!classDefinition.isAuxiliary()) {
            throw NamespaceException.NOT_AUXILIARY_CLASS;
        }
        this.setClassDefinition();
        bl = this.classDefinition.removeElement(classDefinition);
        if (bl) {
            ObjectAttribute objectAttribute;
            String string;
            AttributeDefinition[] attributeDefinitionArray = classDefinition.getMandatoryAttributes();
            AttributeDefinition[] attributeDefinitionArray2 = classDefinition.getOptionalAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                string = attributeDefinitionArray[n].getName();
                if (!this.isClassUsingAttribute(string)) {
                    objectAttribute = (ObjectAttribute)this.attributes.remove(string);
                    if (objectAttribute != null) {
                        objectAttribute.removePropertyChangeListener(this);
                    }
                    this.addedAttributeDefinitions.remove(string);
                }
                ++n;
            }
            n = 0;
            while (n < attributeDefinitionArray2.length) {
                string = attributeDefinitionArray2[n].getName();
                if (!this.isClassUsingAttribute(string)) {
                    objectAttribute = (ObjectAttribute)this.attributes.remove(string);
                    if (objectAttribute != null) {
                        objectAttribute.removePropertyChangeListener(this);
                    }
                    this.addedAttributeDefinitions.remove(string);
                }
                ++n;
            }
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ObjectAttribute objectAttribute = (ObjectAttribute)propertyChangeEvent.getSource();
        objectAttribute.removePropertyChangeListener(this);
        this.modifiedAttributes.addElement(objectAttribute.getName());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyListeners.contains(propertyChangeListener)) {
            this.propertyListeners.addElement(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.removeElement(propertyChangeListener);
    }

    public void clearAddedAttribute(String string) {
        this.addedAttributes.removeElement(string);
        ObjectAttribute objectAttribute = (ObjectAttribute)this.attributes.get(string);
        if (objectAttribute != null) {
            objectAttribute.addPropertyChangeListener(this);
        }
    }

    public void clearAddedAttributeDefinitions() {
        this.addedAttributeDefinitions.clear();
    }

    public void clearDeletedAttribute(String string) {
        this.deletedAttributes.removeElement(string);
    }

    public void clearModifiedAttribute(String string) {
        this.modifiedAttributes.removeElement(string);
        ObjectAttribute objectAttribute = (ObjectAttribute)this.attributes.get(string);
        if (objectAttribute != null) {
            objectAttribute.addPropertyChangeListener(this);
        }
    }

    private void putAttributes(Vector vector) {
        if (vector != null) {
            this.attributes = new Hashtable(vector.size() + 1);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof ObjectAttribute) {
                    ObjectAttribute objectAttribute = (ObjectAttribute)e;
                    String string = objectAttribute.getName();
                    if (this.classDefinition != null && !this.isClassUsingAttribute(string)) continue;
                    this.attributes.put(string, objectAttribute);
                    objectAttribute.addPropertyChangeListener(this);
                    continue;
                }
                if (!(e instanceof String)) continue;
                this.attributes.put(e, e);
            }
        } else {
            this.attributes = new Hashtable(10);
        }
    }

    protected void checkAdd(ObjectAttribute objectAttribute, boolean bl) throws NamespaceException {
        String string = objectAttribute.getName();
        this.setClassDefinition();
        if (objectAttribute.getAttributeDefinition().isReadOnly()) {
            throw NamespaceException.READONLY_ATTRIBUTE;
        }
        if (!this.shadowSign) {
            if (!bl && this.isAttributeMandatory(string)) {
                throw NamespaceException.MANDATORY_ATTRIBUTE;
            }
            if (bl && !this.isAttributeMandatory(string) && !this.isAttributeOptional(string)) {
                throw NamespaceException.INVALID_ATTRIBUTE;
            }
            if (!bl && !this.isAttributeOptional(string)) {
                throw NamespaceException.INVALID_ATTRIBUTE;
            }
        }
        if (this.getAttribute(string) != null) {
            throw NamespaceException.DUPLICATE_ATTRIBUTE;
        }
    }

    public boolean isAttributeMandatory(String string) {
        boolean bl = false;
        this.setClassDefinition();
        Enumeration enumeration = this.classDefinition.elements();
        while (enumeration.hasMoreElements()) {
            if (!((ClassDefinition)enumeration.nextElement()).isAttributeMandatory(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isAttributeOptional(String string) {
        boolean bl = false;
        this.setClassDefinition();
        Enumeration enumeration = this.classDefinition.elements();
        while (enumeration.hasMoreElements()) {
            if (!((ClassDefinition)enumeration.nextElement()).isAttributeOptional(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isNamedBy(String string) {
        boolean bl = false;
        this.setClassDefinition();
        Enumeration enumeration = this.classDefinition.elements();
        while (enumeration.hasMoreElements()) {
            if (!((ClassDefinition)enumeration.nextElement()).isNamedBy(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isClassUsingAttribute(String string) {
        boolean bl = false;
        Enumeration enumeration = this.classDefinition.elements();
        while (enumeration.hasMoreElements()) {
            if (!((ClassDefinition)enumeration.nextElement()).isClassUsingAttribute(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private AttributeDefinition[] getOptionalAttributeDefinitions() {
        Vector<AttributeDefinition> vector = new Vector<AttributeDefinition>();
        Enumeration enumeration = this.classDefinition.elements();
        while (enumeration.hasMoreElements()) {
            AttributeDefinition[] attributeDefinitionArray = ((ClassDefinition)enumeration.nextElement()).getOptionalAttributes();
            int n = 0;
            while (n < attributeDefinitionArray.length) {
                vector.addElement(attributeDefinitionArray[n]);
                ++n;
            }
        }
        Object[] objectArray = new AttributeDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void notifyPropertyChangeListeners(PropertyChangeEvent propertyChangeEvent) {
        Vector vector = (Vector)this.propertyListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    protected void setClassDefinition() {
        if (this.classDefinition != null) {
            return;
        }
        try {
            this.classDefinition = new Vector(10);
            this.classDefinition.addElement(this.namespace.getClassDefinition(this.objectEntry, this.objectEntry.getObjectType().getName()));
        }
        catch (SPIException sPIException) {
            throw new AdminError(1, this.getClass());
        }
        catch (NamespaceException namespaceException) {
            throw new AdminError(3, this.getClass());
        }
    }

    protected DefaultNSObject(ObjectEntry objectEntry, Vector vector, long l) {
        this.objectEntry = objectEntry;
        this.namespace = (AdminNamespace)objectEntry.getObjectType().getNamespace();
        this.revision = l;
        this.putAttributes(vector);
    }
}

