/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.SchemaDefinition;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DefaultSchemaDefinition
extends SchemaDefinition
implements Serializable,
Cloneable {
    public final int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public final int getNumberOfClasses() {
        return this.classes.size();
    }

    public ClassDefinition[] getAuxiliaryClassDefinitions() {
        Hashtable hashtable = this.classes;
        synchronized (hashtable) {
            Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
            Enumeration enumeration = this.classes.elements();
            while (enumeration.hasMoreElements()) {
                ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
                if (!classDefinition.isAuxiliary()) continue;
                vector.addElement(classDefinition);
            }
            Object[] objectArray = new ClassDefinition[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            Object var2_7 = null;
            return objectArray2;
        }
    }

    public ClassDefinition[] getClassDefinitions() {
        Hashtable hashtable = this.classes;
        synchronized (hashtable) {
            Object[] objectArray = new ClassDefinition[this.classes.size()];
            NSUtil.copyIntoArray(this.classes, objectArray);
            Object[] objectArray2 = objectArray;
            Object var2_4 = null;
            return objectArray2;
        }
    }

    public AttributeDefinition[] getAttributeDefinitions() {
        Hashtable hashtable = this.attributes;
        synchronized (hashtable) {
            Object[] objectArray = new AttributeDefinition[this.attributes.size()];
            NSUtil.copyIntoArray(this.attributes, objectArray);
            Object[] objectArray2 = objectArray;
            Object var2_4 = null;
            return objectArray2;
        }
    }

    public ClassDefinition[] getClassesUsingAttribute(String string) {
        Hashtable hashtable = this.classes;
        synchronized (hashtable) {
            Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
            Enumeration enumeration = this.classes.elements();
            while (enumeration.hasMoreElements()) {
                ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
                if (!classDefinition.isClassUsingAttribute(string)) continue;
                vector.addElement(classDefinition);
            }
            Object[] objectArray = new ClassDefinition[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            Object var3_8 = null;
            return objectArray2;
        }
    }

    public AttributeDefinition getAttributeDefinition(String string) throws NamespaceException {
        AttributeDefinition attributeDefinition = (AttributeDefinition)this.attributes.get(string);
        if (attributeDefinition != null) {
            return attributeDefinition;
        }
        throw NamespaceException.ATTRIBUTE_NOT_DEFINED;
    }

    public boolean canContain(String string, String string2) {
        try {
            ClassDefinition[] classDefinitionArray = this.getContainmentClasses(string2);
            int n = 0;
            while (n < classDefinitionArray.length) {
                if (classDefinitionArray[n].getName().equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return false;
    }

    public abstract ClassDefinition[] getContainmentClasses(String var1) throws NamespaceException;

    public ClassDefinition[] getEffectiveClasses(String string) {
        Vector<ClassDefinition> vector = new Vector<ClassDefinition>();
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            ClassDefinition classDefinition = (ClassDefinition)enumeration.nextElement();
            if (!classDefinition.isEffective() || !this.canContain(string, classDefinition.getName())) continue;
            vector.addElement(classDefinition);
        }
        Object[] objectArray = new ClassDefinition[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ClassDefinition getClassDefinition(String string) throws NamespaceException {
        ClassDefinition classDefinition = (ClassDefinition)this.classes.get(string);
        if (classDefinition != null) {
            return classDefinition;
        }
        throw NamespaceException.CLASS_NOT_DEFINED;
    }

    public final boolean isClassDefined(String string) {
        return this.classes.containsKey(string);
    }

    public final boolean isAttributeDefined(String string) {
        return this.attributes.containsKey(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        DefaultSchemaDefinition defaultSchemaDefinition;
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultSchemaDefinition)) {
            return false;
        }
        DefaultSchemaDefinition defaultSchemaDefinition2 = defaultSchemaDefinition = (DefaultSchemaDefinition)object;
        synchronized (defaultSchemaDefinition2) {
            DefaultSchemaDefinition defaultSchemaDefinition3 = this;
            synchronized (defaultSchemaDefinition3) {
                Object v;
                Serializable serializable;
                if (defaultSchemaDefinition.classes.size() != this.classes.size()) return false;
                if (defaultSchemaDefinition.attributes.size() != this.attributes.size()) return false;
                Enumeration enumeration = this.classes.elements();
                while (enumeration.hasMoreElements()) {
                    serializable = (ClassDefinition)enumeration.nextElement();
                    v = defaultSchemaDefinition.classes.get(((ClassDefinition)serializable).getName());
                    if (v == null) {
                        return false;
                    }
                    if (((ClassDefinition)serializable).equals((ClassDefinition)v)) continue;
                    return false;
                }
                enumeration = this.attributes.elements();
                while (enumeration.hasMoreElements()) {
                    serializable = (AttributeDefinition)enumeration.nextElement();
                    v = defaultSchemaDefinition.attributes.get(((AttributeDefinition)serializable).getName());
                    if (v == null) {
                        return false;
                    }
                    if (((AttributeDefinition)serializable).equals((AttributeDefinition)v)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public DefaultSchemaDefinition() {
        this.attributes = new Hashtable(200, 200.0f);
        this.classes = new Hashtable(100, 100.0f);
    }
}

