/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class HexStrategy
implements ValueStrategy {
    private static final int BAD_COMPARE_OBJ = 1;
    private static final int WITHIN_BOUNDS = 2;
    private static final int BAD_TOSTRING_OBJ = 3;

    public boolean canCreateValue(Object object) {
        return object instanceof byte[];
    }

    public ValueComponent createValueComponent() {
        return new HexValue(this.getSyntax(), new byte[1]);
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof byte[]) {
            return new HexValue(this.getSyntax(), (byte[])object);
        }
        throw new ComponentCreationException();
    }

    public boolean equals(ValueComponent valueComponent, ValueComponent valueComponent2) {
        return this.compare(valueComponent, valueComponent2) == 0L;
    }

    public long compare(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof HexValue && valueComponent2 instanceof HexValue) {
            byte[] byArray;
            if (valueComponent.getSyntax() != valueComponent2.getSyntax()) {
                return valueComponent.getSyntax().getId() - valueComponent2.getSyntax().getId();
            }
            HexValue hexValue = (HexValue)valueComponent;
            HexValue hexValue2 = (HexValue)valueComponent2;
            byte[] byArray2 = hexValue.getValue();
            int n = byArray2.length < (byArray = hexValue2.getValue()).length ? byArray2.length : byArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (byArray2[n2] != byArray[n2]) {
                    return byArray2[n2] - byArray[n2];
                }
                ++n2;
            }
            return byArray2.length - byArray.length;
        }
        throw new AdminError(1, this.getClass());
    }

    public String toString(ValueComponent valueComponent) {
        if (valueComponent instanceof HexValue) {
            byte[] byArray = ((HexValue)valueComponent).getValue();
            return NSUtil.toHexString(byArray);
        }
        throw new AdminError(3, this.getClass());
    }

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof HexValue) {
            HexValue hexValue = (HexValue)valueComponent;
            long l3 = hexValue.getLength();
            return l3 >= l && l3 <= l2;
        }
        throw new AdminError(2, this.getClass());
    }

    public abstract Syntax getSyntax();
}

