/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;

public abstract class IntegerStrategy
implements ValueStrategy {
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    protected static final int WITHIN_BOUNDS = 3;
    private static final int BAD_TOSTRING_OBJ = 4;

    public boolean equals(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof LongValue) {
            if (valueComponent.getSyntax() == valueComponent2.getSyntax()) {
                LongValue longValue = (LongValue)valueComponent;
                LongValue longValue2 = (LongValue)valueComponent2;
                return longValue.getValue() == longValue2.getValue();
            }
            return false;
        }
        throw new AdminError(1, this.getClass());
    }

    public long compare(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof LongValue && valueComponent2 instanceof LongValue) {
            if (valueComponent.getSyntax() != valueComponent2.getSyntax()) {
                return valueComponent.getSyntax().getId() - valueComponent2.getSyntax().getId();
            }
            LongValue longValue = (LongValue)valueComponent;
            LongValue longValue2 = (LongValue)valueComponent2;
            return longValue.getValue() - longValue2.getValue();
        }
        throw new AdminError(2, this.getClass());
    }

    public String toString(ValueComponent valueComponent) {
        if (valueComponent instanceof LongValue) {
            return ((LongValue)valueComponent).getLongValue().toString();
        }
        throw new AdminError(4, this.getClass());
    }

    public boolean canCreateValue(Object object) {
        if (object instanceof Number) {
            return true;
        }
        if (object instanceof String) {
            try {
                Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof Number) {
            return new LongValue(this.getSyntax(), ((Number)object).longValue());
        }
        if (object instanceof String) {
            try {
                return new LongValue(this.getSyntax(), Long.parseLong((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ComponentCreationException();
            }
        }
        throw new ComponentCreationException();
    }

    public ValueComponent createValueComponent() {
        return new LongValue(this.getSyntax(), 0L);
    }

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof LongValue) {
            LongValue longValue = (LongValue)valueComponent;
            long l3 = longValue.getValue();
            return l3 >= l && l3 <= l2;
        }
        throw new AdminError(3, this.getClass());
    }

    public abstract Syntax getSyntax();
}

