/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.ns.NSObject;
import com.novell.application.console.snapin.ObjectEntry;
import java.util.Enumeration;
import java.util.Hashtable;

public final class NSObjectCache {
    private Hashtable nsObjectLookupTable = new Hashtable(10, 10.0f);

    public synchronized void setDetails(Object object, NSObject nSObject) {
        if (this.nsObjectLookupTable.containsKey(object)) {
            Hashtable hashtable = (Hashtable)this.nsObjectLookupTable.get(object);
            if (!hashtable.containsKey(nSObject.getObjectEntry().getFullName())) {
                hashtable.put(nSObject.getObjectEntry().getFullName(), nSObject);
            }
        } else {
            this.nsObjectLookupTable.put(object, new Hashtable());
            this.setDetails(object, nSObject);
        }
    }

    public NSObject getDetails(Object object, ObjectEntry objectEntry) {
        return this.getCacheNSObject(object, objectEntry);
    }

    public synchronized void freeDetails(Object object) {
        this.nsObjectLookupTable.remove(object);
    }

    public synchronized void freeDetails(Object object, ObjectEntry objectEntry) {
        if (this.nsObjectLookupTable.containsKey(object)) {
            Hashtable hashtable = (Hashtable)this.nsObjectLookupTable.get(object);
            hashtable.remove(objectEntry.getFullName());
        }
    }

    private NSObject getCacheNSObject(Object object, ObjectEntry objectEntry) {
        NSObject nSObject = null;
        Enumeration enumeration = this.nsObjectLookupTable.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            if (!hashtable.containsKey(objectEntry.getFullName())) continue;
            nSObject = (NSObject)hashtable.get(objectEntry.getFullName());
            if (this.nsObjectLookupTable.containsKey(object)) break;
            this.setDetails(object, nSObject);
            break;
        }
        return nSObject;
    }
}

