/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ObjectAttribute
implements Cloneable,
PropertyChangeListener,
Serializable {
    private static final int MAX_TOSTRING_LENGTH = 256;
    private static final int CLONE = 1;
    protected AttributeDefinition attrDefinition;
    private Vector propertyListeners = new Vector(10);
    protected Vector values = new Vector();
    private Vector beginingValues = new Vector();
    protected Vector addedValues = new Vector();
    protected Vector deletedValues = new Vector();
    protected Vector modifiedValues = new Vector();

    public final void clearAddedAttributeValues() {
        this.addedValues.removeAllElements();
    }

    public final void clearDeletedAttributeValues() {
        this.deletedValues.removeAllElements();
    }

    public final void clearModifiedAttributeValues() {
        this.modifiedValues.removeAllElements();
    }

    public final void resetBeginingAttributeValues() {
        Enumeration enumeration = this.values.elements();
        this.beginingValues = new Vector(this.values.size());
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof ValueList) {
                this.beginingValues.addElement(((ValueList)e).clone());
                continue;
            }
            this.beginingValues.addElement(e);
        }
    }

    public synchronized boolean contains(ValueComponent valueComponent) {
        return this.contains(this.values, valueComponent);
    }

    public final AttributeDefinition getAttributeDefinition() {
        return this.attrDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addComponent(ValueComponent valueComponent) throws NamespaceException {
        if (this.attrDefinition.isReadOnly()) {
            throw NamespaceException.READONLY_ATTRIBUTE;
        }
        if (valueComponent.getSyntax() != this.attrDefinition.getSyntax()) {
            throw NamespaceException.WRONG_SYNTAX;
        }
        if (!this.values.isEmpty() && this.attrDefinition.isSingleValued()) throw NamespaceException.SINGLE_VALUED_ATTRIBUTE;
        if (this.attrDefinition.isSized()) {
            if (!valueComponent.isWithinBounds(this.attrDefinition.getLowerBound(), this.attrDefinition.getUpperBound())) throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
            this.doAdd(valueComponent);
            return;
        } else {
            this.doAdd(valueComponent);
        }
    }

    public synchronized void addComponents(ValueComponent[] valueComponentArray) throws NamespaceException {
        int n = 0;
        while (n < valueComponentArray.length) {
            this.addComponent(valueComponentArray[n]);
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void replaceComponent(ValueComponent valueComponent, ValueComponent valueComponent2) throws NamespaceException {
        if (this.attrDefinition.isReadOnly()) {
            throw NamespaceException.READONLY_ATTRIBUTE;
        }
        if (valueComponent2.getSyntax() != this.attrDefinition.getSyntax()) {
            throw NamespaceException.WRONG_SYNTAX;
        }
        if (this.attrDefinition.isSized()) {
            if (!valueComponent2.isWithinBounds(this.attrDefinition.getLowerBound(), this.attrDefinition.getUpperBound())) throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
            this.doReplace(valueComponent, valueComponent2);
            return;
        } else {
            this.doReplace(valueComponent, valueComponent2);
        }
    }

    public final ValueComponent[] getAddedComponents() {
        Object[] objectArray = new ValueComponent[this.addedValues.size()];
        this.addedValues.copyInto(objectArray);
        return objectArray;
    }

    public final ValueComponent[] getBeginingComponents() {
        Object[] objectArray = new ValueComponent[this.beginingValues.size()];
        this.beginingValues.copyInto(objectArray);
        return objectArray;
    }

    public final ValueComponent[] getDeletedComponents() {
        Object[] objectArray = new ValueComponent[this.deletedValues.size()];
        this.deletedValues.copyInto(objectArray);
        return objectArray;
    }

    public final ModifyValue[] getModifiedComponents() {
        Object[] objectArray = new ModifyValue[this.modifiedValues.size()];
        this.modifiedValues.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration getValueComponents() {
        return this.values.elements();
    }

    public int getComponentCount() {
        return this.values.size();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
            if (stringBuffer.length() >= 256) break;
        }
        return new String(stringBuffer);
    }

    public synchronized void removeAllComponents() {
        if (!this.attrDefinition.isReadOnly()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
            int n = this.values.size() - 1;
            while (n >= 0) {
                ValueComponent valueComponent = (ValueComponent)this.values.elementAt(n);
                if (valueComponent instanceof ValueList) {
                    ((ValueList)valueComponent).removePropertyChangeListener(this);
                }
                this.values.removeElementAt(n);
                --n;
            }
            this.addedValues.removeAllElements();
            this.modifiedValues.removeAllElements();
            this.deletedValues = (Vector)this.beginingValues.clone();
            this.notifyPropertyChangeListeners(propertyChangeEvent);
        }
    }

    public synchronized boolean removeComponent(ValueComponent valueComponent) {
        int n = this.values.indexOf(valueComponent);
        if (n >= 0 && !this.attrDefinition.isReadOnly()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, valueComponent, null);
            this.values.removeElementAt(n);
            if (this.contains(this.beginingValues, valueComponent)) {
                this.deletedValues.addElement(valueComponent);
            } else if (!this.addedValues.removeElement(valueComponent)) {
                this.removeModifyRequest(valueComponent);
            }
            if (valueComponent instanceof ValueList) {
                ((ValueList)valueComponent).removePropertyChangeListener(this);
            }
            this.notifyPropertyChangeListeners(propertyChangeEvent);
            return true;
        }
        return false;
    }

    public final String getName() {
        return this.attrDefinition.getName();
    }

    public synchronized Object clone() {
        try {
            ObjectAttribute objectAttribute = (ObjectAttribute)super.clone();
            objectAttribute.values = (Vector)this.values.clone();
            objectAttribute.propertyListeners = new Vector();
            this.beginingValues = (Vector)this.beginingValues.clone();
            this.addedValues = (Vector)this.addedValues.clone();
            this.deletedValues = (Vector)this.deletedValues.clone();
            this.modifiedValues = (Vector)this.modifiedValues.clone();
            return objectAttribute;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AdminError(1, this.getClass());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent instanceof ValueListPropertyChangeEvent) {
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this, null, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            ValueList valueList = ((ValueListPropertyChangeEvent)propertyChangeEvent).getRootValueList();
            ValueList valueList2 = valueList.getRootListClone();
            boolean bl = this.contains(this.beginingValues, valueList2);
            if (bl && !this.isModifyRequest(valueList2)) {
                ObjectAttribute objectAttribute = this;
                if (objectAttribute == null) {
                    throw null;
                }
                this.modifiedValues.addElement(objectAttribute.new ModifyValue(valueList2, valueList));
            }
            this.notifyPropertyChangeListeners(propertyChangeEvent2);
        }
    }

    protected void notifyPropertyChangeListeners(PropertyChangeEvent propertyChangeEvent) {
        Vector vector = (Vector)this.propertyListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyListeners.contains(propertyChangeListener)) {
            this.propertyListeners.addElement(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.removeElement(propertyChangeListener);
    }

    private boolean contains(Vector vector, ValueComponent valueComponent) {
        int n = 0;
        while (n < vector.size()) {
            if (valueComponent.equals(vector.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void doAdd(ValueComponent valueComponent) throws NamespaceException {
        if (!this.contains(this.values, valueComponent)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, valueComponent);
            this.values.addElement(valueComponent);
            if (!this.contains(this.beginingValues, valueComponent)) {
                this.addedValues.addElement(valueComponent);
                if (valueComponent instanceof ValueList) {
                    ((ValueList)valueComponent).setListAsRoot();
                }
            }
            this.deletedValues.removeElement(valueComponent);
            this.notifyPropertyChangeListeners(propertyChangeEvent);
            if (valueComponent instanceof ValueList) {
                ((ValueList)valueComponent).addPropertyChangeListener(this);
            }
        }
    }

    private void doReplace(ValueComponent valueComponent, ValueComponent valueComponent2) throws NamespaceException {
        int n = this.values.indexOf(valueComponent);
        if (n > -1) {
            if (!this.contains(this.values, valueComponent2)) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, valueComponent, valueComponent2);
                this.values.setElementAt(valueComponent2, n);
                boolean bl = this.contains(this.beginingValues, valueComponent);
                boolean bl2 = this.contains(this.beginingValues, valueComponent2);
                if (bl && !bl2) {
                    ObjectAttribute objectAttribute = this;
                    if (objectAttribute == null) {
                        throw null;
                    }
                    this.modifiedValues.addElement(objectAttribute.new ModifyValue(valueComponent, valueComponent2));
                    if (valueComponent2 instanceof ValueList) {
                        ((ValueList)valueComponent2).setListAsRoot();
                    }
                } else if (!bl && !bl2) {
                    int n2 = this.addedValues.indexOf(valueComponent);
                    if (n2 > -1) {
                        this.addedValues.setElementAt(valueComponent2, n2);
                    } else {
                        this.changeModifyRequest(valueComponent, valueComponent2);
                    }
                    if (valueComponent2 instanceof ValueList) {
                        ((ValueList)valueComponent2).setListAsRoot();
                    }
                } else if (!bl && bl2) {
                    int n3 = this.addedValues.indexOf(valueComponent);
                    if (n3 > -1) {
                        this.addedValues.removeElement(valueComponent);
                    } else {
                        valueComponent = this.removeModifyRequest(valueComponent);
                        this.deletedValues.addElement(valueComponent);
                    }
                    this.deletedValues.removeElement(valueComponent2);
                } else {
                    this.deletedValues.removeElement(valueComponent2);
                    this.deletedValues.addElement(valueComponent);
                }
                if (valueComponent instanceof ValueList) {
                    ((ValueList)valueComponent).removePropertyChangeListener(this);
                    ((ValueList)valueComponent2).addPropertyChangeListener(this);
                }
                this.notifyPropertyChangeListeners(propertyChangeEvent);
            }
        } else {
            throw NamespaceException.VALUE_NOT_FOUND;
        }
    }

    private void changeModifyRequest(ValueComponent valueComponent, ValueComponent valueComponent2) {
        Enumeration enumeration = this.modifiedValues.elements();
        while (enumeration.hasMoreElements()) {
            ModifyValue modifyValue = (ModifyValue)enumeration.nextElement();
            if (!modifyValue.getNewValue().equals(valueComponent)) continue;
            modifyValue.setNewComp(valueComponent2);
            return;
        }
    }

    private ValueComponent removeModifyRequest(ValueComponent valueComponent) {
        Enumeration enumeration = this.modifiedValues.elements();
        ValueComponent valueComponent2 = null;
        while (enumeration.hasMoreElements()) {
            ModifyValue modifyValue = (ModifyValue)enumeration.nextElement();
            if (!modifyValue.getNewValue().equals(valueComponent)) continue;
            valueComponent2 = modifyValue.getOldValue();
            this.modifiedValues.removeElement(modifyValue);
            break;
        }
        return valueComponent2;
    }

    private boolean isModifyRequest(ValueComponent valueComponent) {
        Enumeration enumeration = this.modifiedValues.elements();
        while (enumeration.hasMoreElements()) {
            ModifyValue modifyValue = (ModifyValue)enumeration.nextElement();
            if (!modifyValue.getOriginalComp().equals(valueComponent)) continue;
            return true;
        }
        return false;
    }

    private void initValues(ValueComponent valueComponent) {
        this.values.addElement(valueComponent);
        if (valueComponent instanceof ValueList) {
            ((ValueList)valueComponent).addPropertyChangeListener(this);
            ((ValueList)valueComponent).setListAsRoot();
        }
    }

    public ObjectAttribute(AttributeDefinition attributeDefinition) {
        this.attrDefinition = attributeDefinition;
        this.beginingValues = new Vector();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectAttribute(AttributeDefinition attributeDefinition, ValueComponent[] valueComponentArray) throws NamespaceException {
        this.attrDefinition = attributeDefinition;
        int n = 0;
        while (n < valueComponentArray.length) {
            if (valueComponentArray[n].getSyntax() == attributeDefinition.getSyntax() && (this.values.isEmpty() || !attributeDefinition.isSingleValued())) {
                if (attributeDefinition.isSized()) {
                    if (!valueComponentArray[n].isWithinBounds(attributeDefinition.getLowerBound(), attributeDefinition.getUpperBound())) throw NamespaceException.VALUE_NOT_WITHIN_BOUNDS;
                    this.initValues(valueComponentArray[n]);
                } else {
                    this.initValues(valueComponentArray[n]);
                }
            }
            ++n;
        }
        this.resetBeginingAttributeValues();
    }

    public class ModifyValue {
        private ValueComponent originalComp;
        private ValueComponent newComp;

        public ValueComponent getOriginalComp() {
            return this.originalComp;
        }

        public ValueComponent getOldValue() {
            return this.originalComp;
        }

        public void setNewComp(ValueComponent valueComponent) {
            this.newComp = valueComponent;
        }

        public ValueComponent getNewValue() {
            return this.newComp;
        }

        public ValueComponent getNewComp() {
            return this.newComp;
        }

        ModifyValue(ValueComponent valueComponent, ValueComponent valueComponent2) {
            this.originalComp = valueComponent;
            this.newComp = valueComponent2;
        }
    }
}

