/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.InputStreamFactory;
import com.novell.admin.ns.StreamValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class StreamStrategy
implements ValueStrategy {
    private static final int DISPLAY_FIELD_WIDTH = 256;
    private static final int BAD_EQUAL_OBJ = 1;
    private static final int BAD_COMPARE_OBJ = 2;
    private static final int WITHIN_BOUNDS = 3;

    public boolean canCreateValue(Object object) {
        return object instanceof StreamValue || object instanceof InputStreamFactory;
    }

    public ValueComponent createValueComponent() {
        StreamStrategy streamStrategy = this;
        if (streamStrategy == null) {
            throw null;
        }
        return new StreamValue(this.getSyntax(), streamStrategy.new EmptyStreamFactory());
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof InputStreamFactory) {
            return new StreamValue(this.getSyntax(), (InputStreamFactory)object);
        }
        if (object instanceof StreamValue) {
            return new StreamValue(this.getSyntax(), ((StreamValue)object).getStreamFactory());
        }
        throw new ComponentCreationException();
    }

    public boolean equals(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof StreamValue) {
            return valueComponent == valueComponent2;
        }
        throw new AdminError(1, this.getClass());
    }

    public long compare(ValueComponent valueComponent, ValueComponent valueComponent2) {
        if (valueComponent instanceof StreamValue) {
            if (valueComponent.getSyntax() != valueComponent2.getSyntax()) {
                return valueComponent.getSyntax().getId() - valueComponent2.getSyntax().getId();
            }
            return 0L;
        }
        throw new AdminError(2, this.getClass());
    }

    public String toString(ValueComponent valueComponent) {
        if (valueComponent instanceof StreamValue) {
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[256];
            try {
                InputStream inputStream = ((StreamValue)valueComponent).getValue();
                inputStream.read(byArray);
                if (this.isDataASCII(byArray)) {
                    int n = 0;
                    while (n < byArray.length) {
                        stringBuffer.append((char)byArray[n]);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < byArray.length) {
                        stringBuffer.append(new Byte(byArray[n]).toString());
                        ++n;
                    }
                }
                inputStream.close();
            }
            catch (IOException iOException) {
            }
            catch (SPIException sPIException) {
                // empty catch block
            }
            return stringBuffer.toString();
        }
        return valueComponent.toString();
    }

    public abstract Syntax getSyntax();

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof StreamValue) {
            return false;
        }
        throw new AdminError(3, this.getClass());
    }

    private boolean isDataASCII(byte[] byArray) {
        boolean bl = true;
        int n = 0;
        while (n < byArray.length) {
            if (!(byArray[n] > 31 && byArray[n] < 127 || byArray[n] == 10 || byArray[n] == 13)) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private class EmptyStreamFactory
    implements InputStreamFactory {
        public InputStream getInputStream() {
            return new ByteArrayInputStream(new byte[0]);
        }

        EmptyStreamFactory() {
        }
    }
}

