/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueListPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class ValueList
extends ValueComponent
implements PropertyChangeListener,
Cloneable,
Serializable {
    private static final int BAD_CLONE_IMPL = 1;
    private static final int BAD_FACADE = 2;
    private Vector values = new Vector(10);
    private ValueList rootValueListClone = null;
    private int hashCode = 0;
    private Vector propertyListeners = new Vector(5);
    private Vector hashCodeListeners = new Vector(5);

    public void initList(ValueComponent valueComponent) {
        this.values.addElement(valueComponent);
        if (valueComponent instanceof ValueList) {
            ((ValueList)valueComponent).addPropertyChangeListener(this);
        }
    }

    public ValueComponent getElementAt(int n) throws ArrayIndexOutOfBoundsException {
        return (ValueComponent)this.values.elementAt(n);
    }

    public boolean canInsertComponent(ValueComponent valueComponent) {
        return this.getListStrategy().canInsertComponent(this, valueComponent);
    }

    public boolean canRemoveComponent(ValueComponent valueComponent) {
        return this.getListStrategy().canRemoveComponent(this, valueComponent);
    }

    public synchronized boolean insertComponent(ValueComponent valueComponent) {
        if (this.canInsertComponent(valueComponent)) {
            this.values.addElement(valueComponent);
            ValueListPropertyChangeEvent valueListPropertyChangeEvent = new ValueListPropertyChangeEvent(this, this, null, null, valueComponent);
            this.notifyPropertyChangeListeners(valueListPropertyChangeEvent);
            if (valueComponent instanceof ValueList) {
                ((ValueList)valueComponent).addPropertyChangeListener(this);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean insertComponentAt(ValueComponent valueComponent, int n) throws ArrayIndexOutOfBoundsException {
        if (this.getListStrategy().canInsertComponent(this, valueComponent)) {
            this.values.insertElementAt(valueComponent, n);
            ValueListPropertyChangeEvent valueListPropertyChangeEvent = new ValueListPropertyChangeEvent(this, this, null, null, valueComponent);
            this.notifyPropertyChangeListeners(valueListPropertyChangeEvent);
            if (valueComponent instanceof ValueList) {
                ((ValueList)valueComponent).addPropertyChangeListener(this);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean removeComponent(ValueComponent valueComponent) {
        int n;
        if (this.canRemoveComponent(valueComponent) && (n = this.indexOf(valueComponent)) != -1) {
            this.values.removeElementAt(n);
            ValueListPropertyChangeEvent valueListPropertyChangeEvent = new ValueListPropertyChangeEvent(this, this, null, valueComponent, null);
            if (valueComponent instanceof ValueList) {
                ((ValueList)valueComponent).removePropertyChangeListener(this);
            }
            this.notifyPropertyChangeListeners(valueListPropertyChangeEvent);
            return true;
        }
        return false;
    }

    public synchronized boolean replaceComponent(ValueComponent valueComponent, ValueComponent valueComponent2) {
        int n = this.indexOf(valueComponent);
        if (n != -1) {
            return this.replaceComponentAt(valueComponent2, n);
        }
        return false;
    }

    public synchronized boolean replaceComponentAt(ValueComponent valueComponent, int n) throws ArrayIndexOutOfBoundsException {
        ValueComponent valueComponent2 = this.getElementAt(n);
        if (valueComponent2.getSyntax() == valueComponent.getSyntax()) {
            this.values.setElementAt(valueComponent, n);
            ValueListPropertyChangeEvent valueListPropertyChangeEvent = new ValueListPropertyChangeEvent(this, this, null, valueComponent2, valueComponent);
            if (valueComponent2 instanceof ValueList) {
                ((ValueList)valueComponent2).removePropertyChangeListener(this);
                ((ValueList)valueComponent).addPropertyChangeListener(this);
            }
            this.notifyPropertyChangeListeners(valueListPropertyChangeEvent);
            return true;
        }
        return false;
    }

    public ValueList getRootListClone() {
        return this.rootValueListClone;
    }

    public void setListAsRoot() {
        this.rootValueListClone = (ValueList)this.clone();
    }

    public boolean contains(ValueComponent valueComponent) {
        int n = 0;
        while (n < this.values.size()) {
            if (valueComponent.equals(this.values.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized int indexOf(ValueComponent valueComponent) {
        int n = 0;
        while (n < this.values.size()) {
            if (valueComponent.equals(this.values.elementAt(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getComponentCount() {
        return this.values.size();
    }

    public Enumeration getComponents() {
        return this.values.elements();
    }

    public synchronized Object clone() {
        try {
            ValueList valueList = (ValueList)super.clone();
            valueList.values = (Vector)this.values.clone();
            int n = 0;
            while (n < valueList.values.size()) {
                Object e = valueList.values.elementAt(n);
                if (e instanceof ValueList) {
                    valueList.values.setElementAt(((ValueList)e).clone(), n);
                }
                ++n;
            }
            valueList.propertyListeners = new Vector();
            return valueList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AdminError(1, this.getClass());
        }
    }

    public Object createFacade() {
        try {
            return this.getListStrategy().createFacade(this);
        }
        catch (IncompatibleComponentException incompatibleComponentException) {
            throw new AdminError(2, this.getClass());
        }
    }

    public Vector getAddableSyntaxes() {
        return this.getListStrategy().getAddableSyntaxes(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ValueListPropertyChangeEvent valueListPropertyChangeEvent = (ValueListPropertyChangeEvent)propertyChangeEvent;
        valueListPropertyChangeEvent.setRootValueList(this);
        this.notifyPropertyChangeListeners(propertyChangeEvent);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyListeners.contains(propertyChangeListener)) {
            this.propertyListeners.addElement(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyListeners.removeElement(propertyChangeListener);
    }

    private void notifyPropertyChangeListeners(PropertyChangeEvent propertyChangeEvent) {
        Vector vector = (Vector)this.propertyListeners.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)enumeration.nextElement();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    private ListStrategy getListStrategy() {
        return (ListStrategy)this.getSyntax().getStrategy();
    }

    public ValueList(Syntax syntax) {
        super(syntax);
    }
}

