/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ldap.LDAPSyntax;
import java.util.Vector;

public final class CaseIgnoreListFacade
extends ValueListFacade {
    private static final int COMP_CREATE = 1;
    private static final int ADD_STRING_1 = 2;
    private static final int ADD_STRING_2 = 3;
    private static final int REMOVE_STRING = 4;

    public static ValueList createValueList(String[] stringArray) {
        try {
            Vector<String> vector = new Vector<String>();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(stringArray[n2]);
                ++n2;
            }
            ValueComponent valueComponent = LDAPSyntax.SYN_CI_LIST.createValueComponent(vector);
            return (ValueList)valueComponent;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.ldap.CaseIgnoreListFacade");
        }
    }

    public String[] getStrings() {
        int n = this.valueList.getComponentCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            StringValue stringValue = (StringValue)this.valueList.getElementAt(n2);
            stringArray[n2] = stringValue.getValue();
            ++n2;
        }
        return stringArray;
    }

    public String getString(int n) throws ArrayIndexOutOfBoundsException {
        StringValue stringValue = (StringValue)this.valueList.getElementAt(n);
        return stringValue.getValue();
    }

    public void addString(String string) {
        try {
            ValueComponent valueComponent = LDAPSyntax.SYN_DIRECTORY_STRING.createValueComponent(string);
            if (!this.valueList.insertComponent(valueComponent)) {
                throw new AdminError(2, this.getClass());
            }
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(3, this.getClass());
        }
    }

    public void removeString(int n) throws ArrayIndexOutOfBoundsException {
        ValueComponent valueComponent = this.valueList.getElementAt(n);
        if (!this.valueList.removeComponent(valueComponent)) {
            throw new AdminError(4, this.getClass());
        }
    }

    public void replaceString(String string, int n) throws ArrayIndexOutOfBoundsException {
        this.replaceStringValue(string, n);
    }

    public CaseIgnoreListFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != LDAPSyntax.SYN_CI_LIST) {
            throw new IncompatibleComponentException();
        }
    }
}

