/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.DateValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.TimeStrategy;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ldap.LDAPSyntax;

final class GeneralizedTimeStrategy
extends TimeStrategy {
    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        if (object instanceof Number) {
            long l = ((Number)object).longValue();
            return super.createValueComponent(new Long(l * 1000L));
        }
        return super.createValueComponent(object);
    }

    public Syntax getSyntax() {
        return LDAPSyntax.SYN_GENERALIZEDTIME;
    }

    public boolean isWithinBounds(ValueComponent valueComponent, long l, long l2) {
        if (valueComponent instanceof DateValue) {
            DateValue dateValue = (DateValue)valueComponent;
            long l3 = dateValue.getMillis() / 1000L;
            return l3 >= l && l3 <= l2;
        }
        throw new AdminError(3, this.getClass());
    }

    GeneralizedTimeStrategy() {
    }
}

