/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.DefaultClassDefinition;
import com.novell.admin.ns.ldap.LDAPClassFlags;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class LDAPClassDefinition
extends DefaultClassDefinition {
    private Hashtable namingAttributes = null;
    private Vector superClassNames = null;
    private LDAPClassFlags classFlags = null;
    private String asn1Data;
    private boolean expanded = false;

    public String[] getSuperClasses() {
        Object[] objectArray = new String[this.superClassNames.size()];
        this.superClassNames.copyInto(objectArray);
        return objectArray;
    }

    public boolean isInheritedFrom(String string) {
        return this.superClassNames.contains(string);
    }

    public LDAPClassFlags getClassFlags() {
        return (LDAPClassFlags)this.classFlags.clone();
    }

    public String getASN1Data() {
        return this.asn1Data;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LDAPClassDefinition)) return false;
        LDAPClassDefinition lDAPClassDefinition = (LDAPClassDefinition)object;
        if (!super.equals(object)) {
            return false;
        }
        LDAPClassDefinition lDAPClassDefinition2 = lDAPClassDefinition;
        synchronized (lDAPClassDefinition2) {
            LDAPClassDefinition lDAPClassDefinition3 = this;
            synchronized (lDAPClassDefinition3) {
                Object object2;
                if (lDAPClassDefinition.namingAttributes.size() != this.namingAttributes.size()) return false;
                if (lDAPClassDefinition.superClassNames.size() != this.superClassNames.size()) return false;
                if (lDAPClassDefinition.classFlags.getFlags() != this.classFlags.getFlags()) return false;
                Enumeration<Object> enumeration = this.namingAttributes.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (AttributeDefinition)enumeration.nextElement();
                    Object v = lDAPClassDefinition.namingAttributes.get(((AttributeDefinition)object2).getName());
                    if (v == null) {
                        return false;
                    }
                    if (((AttributeDefinition)object2).equals((AttributeDefinition)v)) continue;
                    return false;
                }
                enumeration = this.superClassNames.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    boolean bl = lDAPClassDefinition.superClassNames.contains(object2);
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public LDAPClassDefinition(String string, LDAPClassFlags lDAPClassFlags, String[] stringArray, String[] stringArray2, AttributeDefinition[] attributeDefinitionArray, AttributeDefinition[] attributeDefinitionArray2, AttributeDefinition[] attributeDefinitionArray3, String string2) {
        super(string, stringArray, attributeDefinitionArray, attributeDefinitionArray2, attributeDefinitionArray3, lDAPClassFlags.isFlagSet(4), lDAPClassFlags.isFlagSet(1), false, lDAPClassFlags.isFlagSet(2));
        int n;
        this.classFlags = (LDAPClassFlags)lDAPClassFlags.clone();
        this.asn1Data = string2;
        if (attributeDefinitionArray2 == null) {
            this.namingAttributes = new Hashtable(1);
        } else {
            this.namingAttributes = new Hashtable(attributeDefinitionArray2.length + 1);
            n = 0;
            while (n < attributeDefinitionArray2.length) {
                AttributeDefinition attributeDefinition = attributeDefinitionArray2[n];
                this.namingAttributes.put(attributeDefinition.getName(), attributeDefinition);
                ++n;
            }
        }
        if (stringArray2 != null) {
            this.superClassNames = new Vector(stringArray2.length);
            n = 0;
            while (n < stringArray2.length) {
                this.superClassNames.addElement(stringArray2[n]);
                ++n;
            }
        } else {
            this.superClassNames = new Vector();
        }
    }
}

