/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.DefaultNSObject;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ldap.LDAPAttributeDefinition;
import com.novell.admin.ns.ldap.LDAPNamespaceException;
import com.novell.admin.ns.ldap.LDAPObjectAttribute;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectType;
import java.util.Enumeration;
import java.util.Vector;

public class LDAPNSObject
extends DefaultNSObject {
    public void initObjectClassAttribute(LDAPObjectAttribute lDAPObjectAttribute) {
        this.attributes.put("objectClass", lDAPObjectAttribute);
    }

    public boolean addAuxiliaryClassDefinition(ClassDefinition classDefinition, ObjectAttribute[] objectAttributeArray) throws NamespaceException {
        boolean bl = super.addAuxiliaryClassDefinition(classDefinition, objectAttributeArray);
        ObjectAttribute objectAttribute = this.getAttribute("Object Class");
        if (objectAttribute == null) {
            throw LDAPNamespaceException.NO_RIGHTS_TO_ADD_AUXILIARY_CLASS;
        }
        return bl;
    }

    public boolean deleteAuxiliaryClassDefinition(ClassDefinition classDefinition) throws NamespaceException {
        ObjectAttribute objectAttribute;
        boolean bl = super.deleteAuxiliaryClassDefinition(classDefinition);
        if (bl && (objectAttribute = this.getAttribute("Object Class")) == null) {
            throw LDAPNamespaceException.NO_RIGHTS_TO_REMOVE_AUXILIARY_CLASS;
        }
        return bl;
    }

    public NSObject clone(ObjectEntry objectEntry) throws NamespaceException {
        ObjectType[] objectTypeArray;
        ObjectType[] objectTypeArray2;
        LDAPNSObject lDAPNSObject = null;
        if (objectEntry.getObjectType() == this.objectEntry.getObjectType() && (objectTypeArray2 = this.objectEntry.getSubTypes()).length == (objectTypeArray = objectEntry.getSubTypes()).length) {
            Vector<ObjectType> vector = new Vector<ObjectType>(objectTypeArray2.length);
            int n = 0;
            while (n < objectTypeArray2.length) {
                vector.addElement(objectTypeArray2[n]);
                ++n;
            }
            n = 0;
            while (n < objectTypeArray2.length) {
                if (!vector.contains(objectTypeArray[n])) {
                    throw NamespaceException.OBJECTTYPE_NOT_VALID;
                }
                ++n;
            }
            lDAPNSObject = (LDAPNSObject)this.clone();
            lDAPNSObject.objectEntry = objectEntry;
            Enumeration enumeration = lDAPNSObject.attributes.elements();
            while (enumeration.hasMoreElements()) {
                ObjectAttribute objectAttribute = (ObjectAttribute)enumeration.nextElement();
                LDAPAttributeDefinition lDAPAttributeDefinition = (LDAPAttributeDefinition)objectAttribute.getAttributeDefinition();
                if (!lDAPAttributeDefinition.getAttributeFlag().isFlagSet(8)) continue;
                lDAPNSObject.attributes.remove(lDAPAttributeDefinition.getName());
            }
            ObjectAttribute objectAttribute = (ObjectAttribute)lDAPNSObject.attributes.get("Object Class");
            String string = objectEntry.getObjectType().getName();
            StringValue stringValue = null;
            Enumeration enumeration2 = objectAttribute.getValueComponents();
            while (enumeration2.hasMoreElements()) {
                stringValue = (StringValue)enumeration2.nextElement();
                if (stringValue.getValue().equals(string)) break;
            }
            objectAttribute.removeAllComponents();
            objectAttribute.addComponent(stringValue);
        }
        if (lDAPNSObject == null) {
            throw NamespaceException.OBJECTTYPE_NOT_VALID;
        }
        return lDAPNSObject;
    }

    static /* synthetic */ ObjectEntry access$0(LDAPNSObject lDAPNSObject) {
        return lDAPNSObject.objectEntry;
    }

    public LDAPNSObject(ObjectEntry objectEntry, Vector vector, long l) {
        super(objectEntry, vector, l);
    }
}

