/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.LongValue;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ValueListFacade;
import com.novell.admin.ns.ldap.LDAPSyntax;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public final class NetAddressFacade
extends ValueListFacade {
    public static final int IPX_ADDRESS_TYPE = 0;
    public static final int IP_ADDRESS_TYPE = 1;
    public static final int SDLC_ADDRESS_TYPE = 2;
    public static final int ET_ADDRESS_TYPE = 3;
    public static final int OSI_ADDRESS_TYPE = 4;
    public static final int APPLETALK_ADDRESS_TYPE = 5;
    public static final int UDP_ADDRESS_TYPE = 8;
    public static final int TCP_ADDRESS_TYPE = 9;
    public static final int URL_ADDRESS_TYPE = 13;
    private static final String IPX_TYPE = "IPX";
    private static final String IP_TYPE = "IP";
    private static final String SDLC_TYPE = "SDLC";
    private static final String ET_TYPE = "Ethernet/Tokenring";
    private static final String OSI_TYPE = "OSI";
    private static final String APPLETALK_TYPE = "Appletalk";
    private static final String UDP_TYPE = "UDP";
    private static final String TCP_TYPE = "TCP";
    private static final String URL_TYPE = "URL";
    private static final int ADDRESS_TYPE_INDEX = 0;
    private static final int ADDRESS_INDEX = 1;
    private static final int COMP_CREATE = 1;

    public static ValueList createValueList(long l, byte[] byArray) {
        try {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(new Long(l));
            vector.addElement(byArray);
            ValueList valueList = (ValueList)LDAPSyntax.SYN_NET_ADDRESS.createValueComponent(vector);
            return valueList;
        }
        catch (ComponentCreationException componentCreationException) {
            throw new AdminError(1, "com.novell.admin.ns.ldap.NetAddressFacade");
        }
    }

    public long getAddressType() {
        LongValue longValue = (LongValue)this.valueList.getElementAt(0);
        return longValue.getValue();
    }

    public byte[] getAddress() {
        HexValue hexValue = (HexValue)this.valueList.getElementAt(1);
        return hexValue.getValue();
    }

    public HexValue getHVAddress() {
        return (HexValue)this.valueList.getElementAt(1);
    }

    public void setAddressType(long l) {
        this.replaceLongValue(l, 0);
    }

    public void setAddress(byte[] byArray) {
        this.replaceHexValue(byArray, 1);
    }

    public String getAddressString() {
        int n = (int)this.getAddressType();
        switch (n) {
            case 0: {
                return this.ipxString();
            }
            case 1: {
                return this.ipString();
            }
            case 2: 
            case 3: {
                return this.seString();
            }
            case 4: 
            case 5: {
                return this.oaString();
            }
            case 8: 
            case 9: {
                return this.tuString();
            }
            case 13: {
                return this.urlString();
            }
        }
        return this.valueList.toString();
    }

    private String ipxString() {
        String string = NSUtil.toHexString(this.getAddress());
        if (string.length() == 24) {
            String string2 = IPX_TYPE;
            string2 = string2.concat(": ");
            string2 = string2.concat(string.substring(0, 8));
            string2 = string2.concat(":");
            string2 = string2.concat(string.substring(8, 20));
            string2 = string2.concat(":");
            string2 = string2.concat(string.substring(20, 24));
            return string2;
        }
        String string3 = IPX_TYPE;
        string3 = string3.concat(": ");
        string3 = string3.concat(string);
        return string3;
    }

    private String ipString() {
        byte[] byArray = this.getAddress();
        if (byArray.length == 4) {
            int n = 0;
            String string = IP_TYPE;
            string = string.concat(": ");
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n++])));
            string = string.concat(".");
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n++])));
            string = string.concat(".");
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n++])));
            string = string.concat(".");
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n])));
            return string;
        }
        String string = IP_TYPE;
        string = string.concat(": ");
        string = string.concat(NSUtil.toHexString(this.getAddress()));
        return string;
    }

    private String seString() {
        String string = NSUtil.toHexString(this.getAddress());
        if (string.length() == 20) {
            String string2 = this.getAddressType() == 2L ? SDLC_TYPE : ET_TYPE;
            string2 = string2.concat(": ");
            string2 = string2.concat(string.substring(0, 4));
            string2 = string2.concat(":");
            string2 = string2.concat(string.substring(4, 10));
            string2 = string2.concat(":");
            string2 = string2.concat(string.substring(10, 20));
            return string2;
        }
        String string3 = this.getAddressType() == 2L ? SDLC_TYPE : ET_TYPE;
        string3 = string3.concat(": ");
        string3 = string3.concat(string);
        return string3;
    }

    private String oaString() {
        String string = this.getAddressType() == 4L ? OSI_TYPE : APPLETALK_TYPE;
        string = string.concat(": ");
        string = string.concat(NSUtil.toHexString(this.getAddress()));
        return string;
    }

    private String urlString() {
        String string;
        int n = 0;
        int n2 = 0;
        byte[] byArray = this.getAddress();
        byte[] byArray2 = new byte[byArray.length];
        while (n < byArray.length) {
            if (byArray[n] != 0) {
                byArray2[n2++] = byArray[n];
            }
            ++n;
        }
        byArray = new byte[n2];
        n = 0;
        while (n < n2) {
            byArray[n] = byArray2[n];
            ++n;
        }
        try {
            string = new String(byArray, "Cp1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = URL_TYPE;
            string = string.concat(": ");
        }
        return string;
    }

    private String tuString() {
        byte[] byArray = this.getAddress();
        if (byArray.length == 6 || byArray.length == 4) {
            int n = 0;
            String string = this.getAddressType() == 8L ? UDP_TYPE : TCP_TYPE;
            string = string.concat(": ");
            if (byArray.length == 6) {
                ++n;
            }
            int n2 = ++n;
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n2])));
            string = string.concat(".");
            int n3 = ++n;
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n3])));
            string = string.concat(".");
            int n4 = ++n;
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[n4])));
            string = string.concat(".");
            string = string.concat(String.valueOf(NSUtil.byteToDecimal(byArray[++n])));
            return string;
        }
        String string = this.getAddressType() == 8L ? UDP_TYPE : TCP_TYPE;
        string = string.concat(": ");
        string = string.concat(NSUtil.toHexString(this.getAddress()));
        return string;
    }

    public NetAddressFacade(ValueList valueList) throws IncompatibleComponentException {
        super(valueList);
        if (valueList.getSyntax() != LDAPSyntax.SYN_NET_ADDRESS) {
            throw new IncompatibleComponentException();
        }
    }
}

