/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.ldap;

import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.ListStrategy;
import com.novell.admin.ns.NSUtil;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.ldap.NetAddressFacade;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

final class NetAddressStrategy
extends ListStrategy {
    public ValueComponent createValueComponent() {
        ValueList valueList = new ValueList(LDAPSyntax.SYN_NET_ADDRESS);
        valueList.initList(LDAPSyntax.SYN_INTEGER.createValueComponent());
        valueList.initList(LDAPSyntax.SYN_OCTET_STRING.createValueComponent());
        return valueList;
    }

    public ValueComponent createValueComponent(Object object) throws ComponentCreationException {
        Vector vector;
        ValueList valueList = new ValueList(LDAPSyntax.SYN_NET_ADDRESS);
        if (object instanceof String) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "#");
            Long l = new Long(stringTokenizer.nextToken());
            byte[] byArray = NSUtil.hexStringToByteArray(stringTokenizer.nextToken());
            valueList.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(l));
            valueList.initList(LDAPSyntax.SYN_OCTET_STRING.createValueComponent(byArray));
            return valueList;
        }
        if (object instanceof Vector && (vector = (Vector)object).size() == 2) {
            Long l = null;
            byte[] byArray = null;
            Vector vector2 = vector;
            synchronized (vector2) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (e instanceof Long) {
                        l = (Long)e;
                        continue;
                    }
                    if (!(e instanceof byte[])) continue;
                    byArray = (byte[])e;
                }
            }
            valueList.initList(LDAPSyntax.SYN_INTEGER.createValueComponent(l));
            valueList.initList(LDAPSyntax.SYN_OCTET_STRING.createValueComponent(byArray));
            return valueList;
        }
        throw new ComponentCreationException();
    }

    public Object createFacade(ValueComponent valueComponent) throws IncompatibleComponentException {
        return new NetAddressFacade((ValueList)valueComponent);
    }

    NetAddressStrategy() {
    }
}

