/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.ns.DefaultAttributeDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.nds.NDSAttributeFlags;
import com.novell.admin.ns.nds.NDSNamespaceException;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;

public class NDSAttributeDefinition
extends DefaultAttributeDefinition {
    private NDSAttributeFlags attrFlags;
    private byte[] asn1Data;

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NDSAttributeDefinition) {
            NDSAttributeDefinition nDSAttributeDefinition = (NDSAttributeDefinition)object;
            if (super.equals(object) && this.attrFlags.equals(nDSAttributeDefinition.attrFlags)) {
                return true;
            }
        }
        return false;
    }

    public final boolean isSingleValued() {
        return this.attrFlags.isFlagSet(1);
    }

    public final boolean isHidden() {
        return this.attrFlags.isFlagSet(16);
    }

    public final boolean isReadOnly() {
        return this.attrFlags.isFlagSet(8);
    }

    public final NDSAttributeFlags getAttributeFlag() {
        return (NDSAttributeFlags)this.attrFlags.clone();
    }

    public final byte[] getASN1Data() {
        byte[] byArray = new byte[this.asn1Data.length];
        System.arraycopy(this.asn1Data, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public ObjectAttribute createAttribute() {
        NDSObjectAttribute nDSObjectAttribute = new NDSObjectAttribute(this);
        try {
            nDSObjectAttribute.addComponent(this.getSyntax().createValueComponent());
        }
        catch (NamespaceException namespaceException) {
            // empty catch block
        }
        return nDSObjectAttribute;
    }

    public boolean isAberrant() {
        return this.name.equals("Object Class");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NDSAttributeDefinition(String string, NDSSyntax nDSSyntax, NDSAttributeFlags nDSAttributeFlags, long l, long l2, byte[] byArray) throws NamespaceException {
        super(string, nDSSyntax, l, l2);
        if (byArray != null) {
            if (byArray.length != 32) {
                this.asn1Data = new byte[32];
                if (byArray.length > 32) {
                    int n = 0;
                    while (n < 32) {
                        this.asn1Data[n] = byArray[n];
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < byArray.length) {
                        this.asn1Data[n] = byArray[n];
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < 32 - byArray.length) {
                        this.asn1Data[n++] = 0;
                        ++n2;
                    }
                }
            } else {
                this.asn1Data = byArray;
            }
        } else {
            this.asn1Data = new byte[32];
            int n = 0;
            while (n < 32) {
                this.asn1Data[n] = 0;
                ++n;
            }
        }
        this.attrFlags = (NDSAttributeFlags)nDSAttributeFlags.clone();
        if (this.attrFlags.isFlagSet(2)) {
            if (!nDSSyntax.isSizable()) throw NDSNamespaceException.ATTRIBUTE_NOT_SIZEABLE;
            this.sized = true;
            return;
        } else {
            this.sized = false;
        }
    }

    public NDSAttributeDefinition(String string, int n, int n2, long l, long l2, byte[] byArray) throws NamespaceException {
        this(string, (NDSSyntax)NDSSyntax.getSyntax(n), new NDSAttributeFlags(n2), l, l2, byArray);
    }
}

