/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.nds.AttrFlag;

public final class NDSAttributeFlags
implements Cloneable {
    public static final int SINGLE_VALUED = 1;
    public static final int SIZED = 2;
    public static final int NONREMOVABLE = 4;
    public static final int READ_ONLY = 8;
    public static final int HIDDEN = 16;
    public static final int STRING = 32;
    public static final int SYNC_IMMEDIATE = 64;
    public static final int PUBLIC_READ = 128;
    public static final int SERVER_READ = 256;
    public static final int WRITE_MANAGED = 512;
    public static final int PER_REPLICA = 1024;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private static final AttrFlag[] attrFlagTable = new AttrFlag[]{new AttrFlag(16, "Hidden"), new AttrFlag(4, "Non-removable"), new AttrFlag(1024, "Per replica"), new AttrFlag(128, "Public Read"), new AttrFlag(8, "Read-only"), new AttrFlag(256, "Server Read"), new AttrFlag(1, "Single valued"), new AttrFlag(2, "Sized"), new AttrFlag(32, "String"), new AttrFlag(64, "Synchronize"), new AttrFlag(512, "Write managed")};
    private int flags;

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object object) {
        if (object instanceof NDSAttributeFlags) {
            NDSAttributeFlags nDSAttributeFlags = (NDSAttributeFlags)object;
            return nDSAttributeFlags.flags == this.flags;
        }
        return false;
    }

    public boolean isFlagSet(int n) {
        return (this.flags & n) != 0;
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public void clearFlag(int n) {
        this.flags &= ~n;
    }

    public String[] getStrings(long l, long l2) {
        int n = 0;
        int n2 = 0;
        while (n2 < attrFlagTable.length) {
            if ((this.flags & NDSAttributeFlags.attrFlagTable[n2].flag) != 0) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        while (n2 < attrFlagTable.length) {
            if ((this.flags & NDSAttributeFlags.attrFlagTable[n2].flag) != 0) {
                stringArray[n++] = 2 == NDSAttributeFlags.attrFlagTable[n2].flag ? new String(NDSAttributeFlags.attrFlagTable[n2].string + " (" + l2 + ".." + l + ")") : NDSAttributeFlags.attrFlagTable[n2].string;
            }
            ++n2;
        }
        return stringArray;
    }

    public Object clone() {
        try {
            return (NDSAttributeFlags)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AdminError(1, this.getClass());
        }
    }

    public NDSAttributeFlags(int n) {
        this.flags = n;
    }
}

