/*
 * Decompiled with CFR 0.152.
 */
package com.novell.admin.ns.nds;

import com.novell.admin.common.exceptions.AdminError;
import com.novell.admin.ns.nds.ClassFlag;

public final class NDSClassFlags
implements Cloneable {
    public static final int CONTAINER_CLASS = 1;
    public static final int EFFECTIVE_CLASS = 2;
    public static final int NONREMOVABLE_CLASS = 4;
    public static final int AMBIGUOUS_NAMING = 8;
    public static final int AMBIGUOUS_CONTAINMENT = 16;
    public static final int AUXILARY_CLASS = 32;
    private static final int CLONE_NOT_SUPPORTED = 1;
    private static final ClassFlag[] classFlagTable = new ClassFlag[]{new ClassFlag(1, "Container"), new ClassFlag(2, "Effective"), new ClassFlag(4, "Non-removable"), new ClassFlag(8, "Ambiguous Naming"), new ClassFlag(16, "Ambiguous Containment"), new ClassFlag(32, "Auxilary")};
    private int flags;

    public int getFlags() {
        return this.flags;
    }

    public boolean isFlagSet(int n) {
        return (this.flags & n) != 0;
    }

    public boolean equals(Object object) {
        if (object instanceof NDSClassFlags) {
            NDSClassFlags nDSClassFlags = (NDSClassFlags)object;
            return nDSClassFlags.getFlags() == this.getFlags();
        }
        return false;
    }

    public Object clone() {
        try {
            return (NDSClassFlags)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AdminError(1, this.getClass());
        }
    }

    public String[] getStrings() {
        int n = 0;
        int n2 = 0;
        while (n2 < classFlagTable.length) {
            if ((this.flags & NDSClassFlags.classFlagTable[n2].flag) != 0) {
                ++n;
            }
            ++n2;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        while (n2 < classFlagTable.length) {
            if ((this.flags & NDSClassFlags.classFlagTable[n2].flag) != 0) {
                stringArray[n++] = NDSClassFlags.classFlagTable[n2].string;
            }
            ++n2;
        }
        return stringArray;
    }

    public NDSClassFlags(int n) {
        this.flags = n;
    }
}

